@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property active When set to true, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order. Default is false.
 */
public data class StackSetManagedExecution(
    public val active: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudformation.outputs.StackSetManagedExecution): StackSetManagedExecution = StackSetManagedExecution(
            active = javaType.active().map({ args0 -> args0 }).orElse(null),
        )
    }
}
