@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin
import com.pulumi.aws.cloudfront.kotlin.outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CachePolicy].
 */
@PulumiTagMarker
public class CachePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CachePolicyArgs = CachePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CachePolicyArgsBuilder.() -> Unit) {
        val builder = CachePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CachePolicy {
        val builtJavaResource = com.pulumi.aws.cloudfront.CachePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CachePolicy(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Use the `aws.cloudfront.CachePolicy` resource to create a cache policy for CloudFront.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.CachePolicy("example", {
 *     name: "example-policy",
 *     comment: "test comment",
 *     defaultTtl: 50,
 *     maxTtl: 100,
 *     minTtl: 1,
 *     parametersInCacheKeyAndForwardedToOrigin: {
 *         cookiesConfig: {
 *             cookieBehavior: "whitelist",
 *             cookies: {
 *                 items: ["example"],
 *             },
 *         },
 *         headersConfig: {
 *             headerBehavior: "whitelist",
 *             headers: {
 *                 items: ["example"],
 *             },
 *         },
 *         queryStringsConfig: {
 *             queryStringBehavior: "whitelist",
 *             queryStrings: {
 *                 items: ["example"],
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.CachePolicy("example",
 *     name="example-policy",
 *     comment="test comment",
 *     default_ttl=50,
 *     max_ttl=100,
 *     min_ttl=1,
 *     parameters_in_cache_key_and_forwarded_to_origin={
 *         "cookies_config": {
 *             "cookie_behavior": "whitelist",
 *             "cookies": {
 *                 "items": ["example"],
 *             },
 *         },
 *         "headers_config": {
 *             "header_behavior": "whitelist",
 *             "headers": {
 *                 "items": ["example"],
 *             },
 *         },
 *         "query_strings_config": {
 *             "query_string_behavior": "whitelist",
 *             "query_strings": {
 *                 "items": ["example"],
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.CachePolicy("example", new()
 *     {
 *         Name = "example-policy",
 *         Comment = "test comment",
 *         DefaultTtl = 50,
 *         MaxTtl = 100,
 *         MinTtl = 1,
 *         ParametersInCacheKeyAndForwardedToOrigin = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs
 *         {
 *             CookiesConfig = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs
 *             {
 *                 CookieBehavior = "whitelist",
 *                 Cookies = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *             HeadersConfig = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs
 *             {
 *                 HeaderBehavior = "whitelist",
 *                 Headers = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *             QueryStringsConfig = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs
 *             {
 *                 QueryStringBehavior = "whitelist",
 *                 QueryStrings = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewCachePolicy(ctx, "example", &cloudfront.CachePolicyArgs{
 * 			Name:       pulumi.String("example-policy"),
 * 			Comment:    pulumi.String("test comment"),
 * 			DefaultTtl: pulumi.Int(50),
 * 			MaxTtl:     pulumi.Int(100),
 * 			MinTtl:     pulumi.Int(1),
 * 			ParametersInCacheKeyAndForwardedToOrigin: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs{
 * 				CookiesConfig: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs{
 * 					CookieBehavior: pulumi.String("whitelist"),
 * 					Cookies: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs{
 * 						Items: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 				HeadersConfig: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs{
 * 					HeaderBehavior: pulumi.String("whitelist"),
 * 					Headers: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs{
 * 						Items: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 				QueryStringsConfig: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs{
 * 					QueryStringBehavior: pulumi.String("whitelist"),
 * 					QueryStrings: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs{
 * 						Items: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.CachePolicy;
 * import com.pulumi.aws.cloudfront.CachePolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachePolicy("example", CachePolicyArgs.builder()
 *             .name("example-policy")
 *             .comment("test comment")
 *             .defaultTtl(50)
 *             .maxTtl(100)
 *             .minTtl(1)
 *             .parametersInCacheKeyAndForwardedToOrigin(CachePolicyParametersInCacheKeyAndForwardedToOriginArgs.builder()
 *                 .cookiesConfig(CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs.builder()
 *                     .cookieBehavior("whitelist")
 *                     .cookies(CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs.builder()
 *                         .items("example")
 *                         .build())
 *                     .build())
 *                 .headersConfig(CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs.builder()
 *                     .headerBehavior("whitelist")
 *                     .headers(CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs.builder()
 *                         .items("example")
 *                         .build())
 *                     .build())
 *                 .queryStringsConfig(CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs.builder()
 *                     .queryStringBehavior("whitelist")
 *                     .queryStrings(CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs.builder()
 *                         .items("example")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:CachePolicy
 *     properties:
 *       name: example-policy
 *       comment: test comment
 *       defaultTtl: 50
 *       maxTtl: 100
 *       minTtl: 1
 *       parametersInCacheKeyAndForwardedToOrigin:
 *         cookiesConfig:
 *           cookieBehavior: whitelist
 *           cookies:
 *             items:
 *               - example
 *         headersConfig:
 *           headerBehavior: whitelist
 *           headers:
 *             items:
 *               - example
 *         queryStringsConfig:
 *           queryStringBehavior: whitelist
 *           queryStrings:
 *             items:
 *               - example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront cache policies using the `id` of the cache policy. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/cachePolicy:CachePolicy policy 658327ea-f89d-4fab-a63d-7e88639e58f6
 * ```
 */
public class CachePolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.CachePolicy,
) : KotlinCustomResource(javaResource, CachePolicyMapper) {
    /**
     * Description for the cache policy.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amount of time, in seconds, that objects are allowed to remain in the CloudFront cache before CloudFront sends a new request to the origin server to check if the object has been updated.
     */
    public val defaultTtl: Output<Int>?
        get() = javaResource.defaultTtl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Current version of the cache policy.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
     */
    public val maxTtl: Output<Int>?
        get() = javaResource.maxTtl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Minimum amount of time, in seconds, that objects should remain in the CloudFront cache before a new request is sent to the origin to check for updates.
     */
    public val minTtl: Output<Int>?
        get() = javaResource.minTtl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Unique name used to identify the cache policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration for including HTTP headers, cookies, and URL query strings in the cache key. For more information, refer to the Parameters In Cache Key And Forwarded To Origin section.
     */
    public val parametersInCacheKeyAndForwardedToOrigin:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOrigin>
        get() = javaResource.parametersInCacheKeyAndForwardedToOrigin().applyValue({ args0 ->
            args0.let({ args0 -> toKotlin(args0) })
        })
}

public object CachePolicyMapper : ResourceMapper<CachePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.CachePolicy::class == javaResource::class

    override fun map(javaResource: Resource): CachePolicy = CachePolicy(
        javaResource as
            com.pulumi.aws.cloudfront.CachePolicy,
    )
}

/**
 * @see [CachePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CachePolicy].
 */
public suspend fun cachePolicy(name: String, block: suspend CachePolicyResourceBuilder.() -> Unit): CachePolicy {
    val builder = CachePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CachePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cachePolicy(name: String): CachePolicy {
    val builder = CachePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
