@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.CachePolicyArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Use the `aws.cloudfront.CachePolicy` resource to create a cache policy for CloudFront.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.CachePolicy("example", {
 *     name: "example-policy",
 *     comment: "test comment",
 *     defaultTtl: 50,
 *     maxTtl: 100,
 *     minTtl: 1,
 *     parametersInCacheKeyAndForwardedToOrigin: {
 *         cookiesConfig: {
 *             cookieBehavior: "whitelist",
 *             cookies: {
 *                 items: ["example"],
 *             },
 *         },
 *         headersConfig: {
 *             headerBehavior: "whitelist",
 *             headers: {
 *                 items: ["example"],
 *             },
 *         },
 *         queryStringsConfig: {
 *             queryStringBehavior: "whitelist",
 *             queryStrings: {
 *                 items: ["example"],
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.CachePolicy("example",
 *     name="example-policy",
 *     comment="test comment",
 *     default_ttl=50,
 *     max_ttl=100,
 *     min_ttl=1,
 *     parameters_in_cache_key_and_forwarded_to_origin={
 *         "cookies_config": {
 *             "cookie_behavior": "whitelist",
 *             "cookies": {
 *                 "items": ["example"],
 *             },
 *         },
 *         "headers_config": {
 *             "header_behavior": "whitelist",
 *             "headers": {
 *                 "items": ["example"],
 *             },
 *         },
 *         "query_strings_config": {
 *             "query_string_behavior": "whitelist",
 *             "query_strings": {
 *                 "items": ["example"],
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.CachePolicy("example", new()
 *     {
 *         Name = "example-policy",
 *         Comment = "test comment",
 *         DefaultTtl = 50,
 *         MaxTtl = 100,
 *         MinTtl = 1,
 *         ParametersInCacheKeyAndForwardedToOrigin = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs
 *         {
 *             CookiesConfig = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs
 *             {
 *                 CookieBehavior = "whitelist",
 *                 Cookies = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *             HeadersConfig = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs
 *             {
 *                 HeaderBehavior = "whitelist",
 *                 Headers = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *             QueryStringsConfig = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs
 *             {
 *                 QueryStringBehavior = "whitelist",
 *                 QueryStrings = new Aws.CloudFront.Inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewCachePolicy(ctx, "example", &cloudfront.CachePolicyArgs{
 * 			Name:       pulumi.String("example-policy"),
 * 			Comment:    pulumi.String("test comment"),
 * 			DefaultTtl: pulumi.Int(50),
 * 			MaxTtl:     pulumi.Int(100),
 * 			MinTtl:     pulumi.Int(1),
 * 			ParametersInCacheKeyAndForwardedToOrigin: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs{
 * 				CookiesConfig: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs{
 * 					CookieBehavior: pulumi.String("whitelist"),
 * 					Cookies: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs{
 * 						Items: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 				HeadersConfig: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs{
 * 					HeaderBehavior: pulumi.String("whitelist"),
 * 					Headers: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs{
 * 						Items: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 				QueryStringsConfig: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs{
 * 					QueryStringBehavior: pulumi.String("whitelist"),
 * 					QueryStrings: &cloudfront.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs{
 * 						Items: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.CachePolicy;
 * import com.pulumi.aws.cloudfront.CachePolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachePolicy("example", CachePolicyArgs.builder()
 *             .name("example-policy")
 *             .comment("test comment")
 *             .defaultTtl(50)
 *             .maxTtl(100)
 *             .minTtl(1)
 *             .parametersInCacheKeyAndForwardedToOrigin(CachePolicyParametersInCacheKeyAndForwardedToOriginArgs.builder()
 *                 .cookiesConfig(CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs.builder()
 *                     .cookieBehavior("whitelist")
 *                     .cookies(CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs.builder()
 *                         .items("example")
 *                         .build())
 *                     .build())
 *                 .headersConfig(CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs.builder()
 *                     .headerBehavior("whitelist")
 *                     .headers(CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs.builder()
 *                         .items("example")
 *                         .build())
 *                     .build())
 *                 .queryStringsConfig(CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs.builder()
 *                     .queryStringBehavior("whitelist")
 *                     .queryStrings(CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs.builder()
 *                         .items("example")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:CachePolicy
 *     properties:
 *       name: example-policy
 *       comment: test comment
 *       defaultTtl: 50
 *       maxTtl: 100
 *       minTtl: 1
 *       parametersInCacheKeyAndForwardedToOrigin:
 *         cookiesConfig:
 *           cookieBehavior: whitelist
 *           cookies:
 *             items:
 *               - example
 *         headersConfig:
 *           headerBehavior: whitelist
 *           headers:
 *             items:
 *               - example
 *         queryStringsConfig:
 *           queryStringBehavior: whitelist
 *           queryStrings:
 *             items:
 *               - example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront cache policies using the `id` of the cache policy. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/cachePolicy:CachePolicy policy 658327ea-f89d-4fab-a63d-7e88639e58f6
 * ```
 * @property comment Description for the cache policy.
 * @property defaultTtl Amount of time, in seconds, that objects are allowed to remain in the CloudFront cache before CloudFront sends a new request to the origin server to check if the object has been updated.
 * @property maxTtl Maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
 * @property minTtl Minimum amount of time, in seconds, that objects should remain in the CloudFront cache before a new request is sent to the origin to check for updates.
 * @property name Unique name used to identify the cache policy.
 * @property parametersInCacheKeyAndForwardedToOrigin Configuration for including HTTP headers, cookies, and URL query strings in the cache key. For more information, refer to the Parameters In Cache Key And Forwarded To Origin section.
 */
public data class CachePolicyArgs(
    public val comment: Output<String>? = null,
    public val defaultTtl: Output<Int>? = null,
    public val maxTtl: Output<Int>? = null,
    public val minTtl: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val parametersInCacheKeyAndForwardedToOrigin: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.CachePolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.CachePolicyArgs =
        com.pulumi.aws.cloudfront.CachePolicyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .defaultTtl(defaultTtl?.applyValue({ args0 -> args0 }))
            .maxTtl(maxTtl?.applyValue({ args0 -> args0 }))
            .minTtl(minTtl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parametersInCacheKeyAndForwardedToOrigin(
                parametersInCacheKeyAndForwardedToOrigin?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [CachePolicyArgs].
 */
@PulumiTagMarker
public class CachePolicyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var defaultTtl: Output<Int>? = null

    private var maxTtl: Output<Int>? = null

    private var minTtl: Output<Int>? = null

    private var name: Output<String>? = null

    private var parametersInCacheKeyAndForwardedToOrigin:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginArgs>? = null

    /**
     * @param value Description for the cache policy.
     */
    @JvmName("rxebhoalcxaexqgx")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Amount of time, in seconds, that objects are allowed to remain in the CloudFront cache before CloudFront sends a new request to the origin server to check if the object has been updated.
     */
    @JvmName("xtpryqanseegjdvc")
    public suspend fun defaultTtl(`value`: Output<Int>) {
        this.defaultTtl = value
    }

    /**
     * @param value Maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
     */
    @JvmName("ystchigwjxogxbpq")
    public suspend fun maxTtl(`value`: Output<Int>) {
        this.maxTtl = value
    }

    /**
     * @param value Minimum amount of time, in seconds, that objects should remain in the CloudFront cache before a new request is sent to the origin to check for updates.
     */
    @JvmName("ysnkibstmjbaampx")
    public suspend fun minTtl(`value`: Output<Int>) {
        this.minTtl = value
    }

    /**
     * @param value Unique name used to identify the cache policy.
     */
    @JvmName("dpgtssvqmtakpjqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for including HTTP headers, cookies, and URL query strings in the cache key. For more information, refer to the Parameters In Cache Key And Forwarded To Origin section.
     */
    @JvmName("mbbcrahvbduypmjy")
    public suspend fun parametersInCacheKeyAndForwardedToOrigin(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginArgs>) {
        this.parametersInCacheKeyAndForwardedToOrigin = value
    }

    /**
     * @param value Description for the cache policy.
     */
    @JvmName("kdmguemenqbrqqdc")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Amount of time, in seconds, that objects are allowed to remain in the CloudFront cache before CloudFront sends a new request to the origin server to check if the object has been updated.
     */
    @JvmName("cykxfxfbaembuxrf")
    public suspend fun defaultTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtl = mapped
    }

    /**
     * @param value Maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated.
     */
    @JvmName("iupjgbmijqyuqbmn")
    public suspend fun maxTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTtl = mapped
    }

    /**
     * @param value Minimum amount of time, in seconds, that objects should remain in the CloudFront cache before a new request is sent to the origin to check for updates.
     */
    @JvmName("rjvdokijcbrwxdef")
    public suspend fun minTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTtl = mapped
    }

    /**
     * @param value Unique name used to identify the cache policy.
     */
    @JvmName("ujdbmgusltqymkef")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for including HTTP headers, cookies, and URL query strings in the cache key. For more information, refer to the Parameters In Cache Key And Forwarded To Origin section.
     */
    @JvmName("hgpufpiwdgoejqdr")
    public suspend fun parametersInCacheKeyAndForwardedToOrigin(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parametersInCacheKeyAndForwardedToOrigin = mapped
    }

    /**
     * @param argument Configuration for including HTTP headers, cookies, and URL query strings in the cache key. For more information, refer to the Parameters In Cache Key And Forwarded To Origin section.
     */
    @JvmName("ibgwamfopvlfjssv")
    public suspend fun parametersInCacheKeyAndForwardedToOrigin(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginArgsBuilder.() -> Unit) {
        val toBeMapped = CachePolicyParametersInCacheKeyAndForwardedToOriginArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parametersInCacheKeyAndForwardedToOrigin = mapped
    }

    internal fun build(): CachePolicyArgs = CachePolicyArgs(
        comment = comment,
        defaultTtl = defaultTtl,
        maxTtl = maxTtl,
        minTtl = minTtl,
        name = name,
        parametersInCacheKeyAndForwardedToOrigin = parametersInCacheKeyAndForwardedToOrigin,
    )
}
