@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.CloudfrontFunctions.getCachePolicyPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getDistributionPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getFunctionPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getLogDeliveryCanonicalUserIdPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginAccessControlPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginAccessIdentitiesPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginAccessIdentityPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getOriginRequestPolicyPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getRealtimeLogConfigPlain
import com.pulumi.aws.cloudfront.CloudfrontFunctions.getResponseHeadersPolicyPlain
import com.pulumi.aws.cloudfront.kotlin.inputs.GetCachePolicyPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetCachePolicyPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetDistributionPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetDistributionPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetFunctionPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetFunctionPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetLogDeliveryCanonicalUserIdPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetLogDeliveryCanonicalUserIdPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessControlPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessControlPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentitiesPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentitiesPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentityPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginAccessIdentityPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginRequestPolicyPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetOriginRequestPolicyPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetRealtimeLogConfigPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetRealtimeLogConfigPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.GetResponseHeadersPolicyPlainArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.GetResponseHeadersPolicyPlainArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetDistributionResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetFunctionResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetLogDeliveryCanonicalUserIdResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessControlResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentitiesResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentityResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetRealtimeLogConfigResult
import com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudfront.kotlin.outputs.GetCachePolicyResult.Companion.toKotlin as getCachePolicyResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetDistributionResult.Companion.toKotlin as getDistributionResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetFunctionResult.Companion.toKotlin as getFunctionResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetLogDeliveryCanonicalUserIdResult.Companion.toKotlin as getLogDeliveryCanonicalUserIdResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessControlResult.Companion.toKotlin as getOriginAccessControlResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentitiesResult.Companion.toKotlin as getOriginAccessIdentitiesResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginAccessIdentityResult.Companion.toKotlin as getOriginAccessIdentityResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetOriginRequestPolicyResult.Companion.toKotlin as getOriginRequestPolicyResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetRealtimeLogConfigResult.Companion.toKotlin as getRealtimeLogConfigResultToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.GetResponseHeadersPolicyResult.Companion.toKotlin as getResponseHeadersPolicyResultToKotlin

public object CloudfrontFunctions {
    /**
     * Use this data source to retrieve information about a CloudFront cache policy.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getCachePolicy({
     *     name: "example-policy",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_cache_policy(name="example-policy")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetCachePolicy.Invoke(new()
     *     {
     *         Name = "example-policy",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupCachePolicy(ctx, &cloudfront.LookupCachePolicyArgs{
     * 			Name: pulumi.StringRef("example-policy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetCachePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getCachePolicy(GetCachePolicyArgs.builder()
     *             .name("example-policy")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getCachePolicy
     *       Arguments:
     *         name: example-policy
     * ```
     * <!--End PulumiCodeChooser -->
     * ### AWS-Managed Policies
     * AWS managed cache policy names are prefixed with `Managed-`:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getCachePolicy({
     *     name: "Managed-CachingOptimized",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_cache_policy(name="Managed-CachingOptimized")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetCachePolicy.Invoke(new()
     *     {
     *         Name = "Managed-CachingOptimized",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupCachePolicy(ctx, &cloudfront.LookupCachePolicyArgs{
     * 			Name: pulumi.StringRef("Managed-CachingOptimized"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetCachePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getCachePolicy(GetCachePolicyArgs.builder()
     *             .name("Managed-CachingOptimized")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getCachePolicy
     *       Arguments:
     *         name: Managed-CachingOptimized
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCachePolicy.
     * @return A collection of values returned by getCachePolicy.
     */
    public suspend fun getCachePolicy(argument: GetCachePolicyPlainArgs): GetCachePolicyResult =
        getCachePolicyResultToKotlin(getCachePolicyPlain(argument.toJava()).await())

    /**
     * @see [getCachePolicy].
     * @param id Identifier for the cache policy.
     * @param name Unique name to identify the cache policy.
     * @return A collection of values returned by getCachePolicy.
     */
    public suspend fun getCachePolicy(id: String? = null, name: String? = null): GetCachePolicyResult {
        val argument = GetCachePolicyPlainArgs(
            id = id,
            name = name,
        )
        return getCachePolicyResultToKotlin(getCachePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getCachePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetCachePolicyPlainArgs].
     * @return A collection of values returned by getCachePolicy.
     */
    public suspend fun getCachePolicy(argument: suspend GetCachePolicyPlainArgsBuilder.() -> Unit): GetCachePolicyResult {
        val builder = GetCachePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCachePolicyResultToKotlin(getCachePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information about a CloudFront distribution.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.cloudfront.getDistribution({
     *     id: "EDFDVBD632BHDS5",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.cloudfront.get_distribution(id="EDFDVBD632BHDS5")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.CloudFront.GetDistribution.Invoke(new()
     *     {
     *         Id = "EDFDVBD632BHDS5",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupDistribution(ctx, &cloudfront.LookupDistributionArgs{
     * 			Id: "EDFDVBD632BHDS5",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetDistributionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CloudfrontFunctions.getDistribution(GetDistributionArgs.builder()
     *             .id("EDFDVBD632BHDS5")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:cloudfront:getDistribution
     *       Arguments:
     *         id: EDFDVBD632BHDS5
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDistribution.
     * @return A collection of values returned by getDistribution.
     */
    public suspend fun getDistribution(argument: GetDistributionPlainArgs): GetDistributionResult =
        getDistributionResultToKotlin(getDistributionPlain(argument.toJava()).await())

    /**
     * @see [getDistribution].
     * @param id Identifier for the distribution. For example: `EDFDVBD632BHDS5`.
     * @param tags
     * @return A collection of values returned by getDistribution.
     */
    public suspend fun getDistribution(id: String, tags: Map<String, String>? = null): GetDistributionResult {
        val argument = GetDistributionPlainArgs(
            id = id,
            tags = tags,
        )
        return getDistributionResultToKotlin(getDistributionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDistribution].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetDistributionPlainArgs].
     * @return A collection of values returned by getDistribution.
     */
    public suspend fun getDistribution(argument: suspend GetDistributionPlainArgsBuilder.() -> Unit): GetDistributionResult {
        val builder = GetDistributionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDistributionResultToKotlin(getDistributionPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a CloudFront Function.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const functionName = config.require("functionName");
     * const existing = aws.cloudfront.getFunction({
     *     name: functionName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * function_name = config.require("functionName")
     * existing = aws.cloudfront.get_function(name=function_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var functionName = config.Require("functionName");
     *     var existing = Aws.CloudFront.GetFunction.Invoke(new()
     *     {
     *         Name = functionName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		functionName := cfg.Require("functionName")
     * 		_, err := cloudfront.LookupFunction(ctx, &cloudfront.LookupFunctionArgs{
     * 			Name: functionName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetFunctionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var functionName = config.get("functionName");
     *         final var existing = CloudfrontFunctions.getFunction(GetFunctionArgs.builder()
     *             .name(functionName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   functionName:
     *     type: string
     * variables:
     *   existing:
     *     fn::invoke:
     *       Function: aws:cloudfront:getFunction
     *       Arguments:
     *         name: ${functionName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFunction.
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(argument: GetFunctionPlainArgs): GetFunctionResult =
        getFunctionResultToKotlin(getFunctionPlain(argument.toJava()).await())

    /**
     * @see [getFunction].
     * @param name Name of the CloudFront function.
     * @param stage Function’s stage, either `DEVELOPMENT` or `LIVE`.
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(name: String, stage: String): GetFunctionResult {
        val argument = GetFunctionPlainArgs(
            name = name,
            stage = stage,
        )
        return getFunctionResultToKotlin(getFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getFunction].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetFunctionPlainArgs].
     * @return A collection of values returned by getFunction.
     */
    public suspend fun getFunction(argument: suspend GetFunctionPlainArgsBuilder.() -> Unit): GetFunctionResult {
        val builder = GetFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFunctionResultToKotlin(getFunctionPlain(builtArgument.toJava()).await())
    }

    /**
     * The CloudFront Log Delivery Canonical User ID data source allows access to the [canonical user ID](http://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html) of the AWS `awslogsdelivery` account for CloudFront bucket logging.
     * See the [Amazon CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) for more information.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getLogDeliveryCanonicalUserId({});
     * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example"});
     * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
     *     bucket: exampleBucketV2.id,
     *     accessControlPolicy: {
     *         grants: [{
     *             grantee: {
     *                 id: example.then(example => example.id),
     *                 type: "CanonicalUser",
     *             },
     *             permission: "FULL_CONTROL",
     *         }],
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_log_delivery_canonical_user_id()
     * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example")
     * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
     *     bucket=example_bucket_v2.id,
     *     access_control_policy={
     *         "grants": [{
     *             "grantee": {
     *                 "id": example.id,
     *                 "type": "CanonicalUser",
     *             },
     *             "permission": "FULL_CONTROL",
     *         }],
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetLogDeliveryCanonicalUserId.Invoke();
     *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
     *     {
     *         Bucket = "example",
     *     });
     *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
     *     {
     *         Bucket = exampleBucketV2.Id,
     *         AccessControlPolicy = new Aws.S3.Inputs.BucketAclV2AccessControlPolicyArgs
     *         {
     *             Grants = new[]
     *             {
     *                 new Aws.S3.Inputs.BucketAclV2AccessControlPolicyGrantArgs
     *                 {
     *                     Grantee = new Aws.S3.Inputs.BucketAclV2AccessControlPolicyGrantGranteeArgs
     *                     {
     *                         Id = example.Apply(getLogDeliveryCanonicalUserIdResult => getLogDeliveryCanonicalUserIdResult.Id),
     *                         Type = "CanonicalUser",
     *                     },
     *                     Permission = "FULL_CONTROL",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cloudfront.GetLogDeliveryCanonicalUserId(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
     * 			Bucket: pulumi.String("example"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
     * 			Bucket: exampleBucketV2.ID(),
     * 			AccessControlPolicy: &s3.BucketAclV2AccessControlPolicyArgs{
     * 				Grants: s3.BucketAclV2AccessControlPolicyGrantArray{
     * 					&s3.BucketAclV2AccessControlPolicyGrantArgs{
     * 						Grantee: &s3.BucketAclV2AccessControlPolicyGrantGranteeArgs{
     * 							Id:   pulumi.String(example.Id),
     * 							Type: pulumi.String("CanonicalUser"),
     * 						},
     * 						Permission: pulumi.String("FULL_CONTROL"),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetLogDeliveryCanonicalUserIdArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketV2Args;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.s3.inputs.BucketAclV2AccessControlPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getLogDeliveryCanonicalUserId();
     *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
     *             .bucket("example")
     *             .build());
     *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
     *             .bucket(exampleBucketV2.id())
     *             .accessControlPolicy(BucketAclV2AccessControlPolicyArgs.builder()
     *                 .grants(BucketAclV2AccessControlPolicyGrantArgs.builder()
     *                     .grantee(BucketAclV2AccessControlPolicyGrantGranteeArgs.builder()
     *                         .id(example.applyValue(getLogDeliveryCanonicalUserIdResult -> getLogDeliveryCanonicalUserIdResult.id()))
     *                         .type("CanonicalUser")
     *                         .build())
     *                     .permission("FULL_CONTROL")
     *                     .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   exampleBucketV2:
     *     type: aws:s3:BucketV2
     *     name: example
     *     properties:
     *       bucket: example
     *   exampleBucketAclV2:
     *     type: aws:s3:BucketAclV2
     *     name: example
     *     properties:
     *       bucket: ${exampleBucketV2.id}
     *       accessControlPolicy:
     *         grants:
     *           - grantee:
     *               id: ${example.id}
     *               type: CanonicalUser
     *             permission: FULL_CONTROL
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getLogDeliveryCanonicalUserId
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLogDeliveryCanonicalUserId.
     * @return A collection of values returned by getLogDeliveryCanonicalUserId.
     */
    public suspend fun getLogDeliveryCanonicalUserId(argument: GetLogDeliveryCanonicalUserIdPlainArgs): GetLogDeliveryCanonicalUserIdResult =
        getLogDeliveryCanonicalUserIdResultToKotlin(getLogDeliveryCanonicalUserIdPlain(argument.toJava()).await())

    /**
     * @see [getLogDeliveryCanonicalUserId].
     * @param region Region you'd like the zone for. By default, fetches the current region.
     * @return A collection of values returned by getLogDeliveryCanonicalUserId.
     */
    public suspend fun getLogDeliveryCanonicalUserId(region: String? = null): GetLogDeliveryCanonicalUserIdResult {
        val argument = GetLogDeliveryCanonicalUserIdPlainArgs(
            region = region,
        )
        return getLogDeliveryCanonicalUserIdResultToKotlin(getLogDeliveryCanonicalUserIdPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogDeliveryCanonicalUserId].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetLogDeliveryCanonicalUserIdPlainArgs].
     * @return A collection of values returned by getLogDeliveryCanonicalUserId.
     */
    public suspend fun getLogDeliveryCanonicalUserId(argument: suspend GetLogDeliveryCanonicalUserIdPlainArgsBuilder.() -> Unit): GetLogDeliveryCanonicalUserIdResult {
        val builder = GetLogDeliveryCanonicalUserIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogDeliveryCanonicalUserIdResultToKotlin(getLogDeliveryCanonicalUserIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information for an Amazon CloudFront origin access control config.
     * ## Example Usage
     * The below example retrieves a CloudFront origin access control config.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getOriginAccessControl({
     *     id: "E2T5VTFBZJ3BJB",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_origin_access_control(id="E2T5VTFBZJ3BJB")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetOriginAccessControl.Invoke(new()
     *     {
     *         Id = "E2T5VTFBZJ3BJB",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupOriginAccessControl(ctx, &cloudfront.LookupOriginAccessControlArgs{
     * 			Id: "E2T5VTFBZJ3BJB",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessControlArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessControl(GetOriginAccessControlArgs.builder()
     *             .id("E2T5VTFBZJ3BJB")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getOriginAccessControl
     *       Arguments:
     *         id: E2T5VTFBZJ3BJB
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOriginAccessControl.
     * @return A collection of values returned by getOriginAccessControl.
     */
    public suspend fun getOriginAccessControl(argument: GetOriginAccessControlPlainArgs): GetOriginAccessControlResult =
        getOriginAccessControlResultToKotlin(getOriginAccessControlPlain(argument.toJava()).await())

    /**
     * @see [getOriginAccessControl].
     * @param id The identifier for the origin access control settings. For example: `E2T5VTFBZJ3BJB`.
     * @return A collection of values returned by getOriginAccessControl.
     */
    public suspend fun getOriginAccessControl(id: String): GetOriginAccessControlResult {
        val argument = GetOriginAccessControlPlainArgs(
            id = id,
        )
        return getOriginAccessControlResultToKotlin(getOriginAccessControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginAccessControl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginAccessControlPlainArgs].
     * @return A collection of values returned by getOriginAccessControl.
     */
    public suspend fun getOriginAccessControl(argument: suspend GetOriginAccessControlPlainArgsBuilder.() -> Unit): GetOriginAccessControlResult {
        val builder = GetOriginAccessControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginAccessControlResultToKotlin(getOriginAccessControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get ARNs, ids and S3 canonical user IDs of Amazon CloudFront origin access identities.
     * ## Example Usage
     * ### All origin access identities in the account
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getOriginAccessIdentities({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_origin_access_identities()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetOriginAccessIdentities.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.GetOriginAccessIdentities(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessIdentities();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getOriginAccessIdentities
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Origin access identities filtered by comment/name
     * Origin access identities whose comments are `example-comment1`, `example-comment2`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getOriginAccessIdentities({
     *     comments: [
     *         "example-comment1",
     *         "example-comment2",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_origin_access_identities(comments=[
     *     "example-comment1",
     *     "example-comment2",
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetOriginAccessIdentities.Invoke(new()
     *     {
     *         Comments = new[]
     *         {
     *             "example-comment1",
     *             "example-comment2",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.GetOriginAccessIdentities(ctx, &cloudfront.GetOriginAccessIdentitiesArgs{
     * 			Comments: []string{
     * 				"example-comment1",
     * 				"example-comment2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentitiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessIdentities(GetOriginAccessIdentitiesArgs.builder()
     *             .comments(
     *                 "example-comment1",
     *                 "example-comment2")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getOriginAccessIdentities
     *       Arguments:
     *         comments:
     *           - example-comment1
     *           - example-comment2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOriginAccessIdentities.
     * @return A collection of values returned by getOriginAccessIdentities.
     */
    public suspend fun getOriginAccessIdentities(argument: GetOriginAccessIdentitiesPlainArgs): GetOriginAccessIdentitiesResult =
        getOriginAccessIdentitiesResultToKotlin(getOriginAccessIdentitiesPlain(argument.toJava()).await())

    /**
     * @see [getOriginAccessIdentities].
     * @param comments Filter origin access identities by comment.
     * @return A collection of values returned by getOriginAccessIdentities.
     */
    public suspend fun getOriginAccessIdentities(comments: List<String>? = null): GetOriginAccessIdentitiesResult {
        val argument = GetOriginAccessIdentitiesPlainArgs(
            comments = comments,
        )
        return getOriginAccessIdentitiesResultToKotlin(getOriginAccessIdentitiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginAccessIdentities].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginAccessIdentitiesPlainArgs].
     * @return A collection of values returned by getOriginAccessIdentities.
     */
    public suspend fun getOriginAccessIdentities(argument: suspend GetOriginAccessIdentitiesPlainArgsBuilder.() -> Unit): GetOriginAccessIdentitiesResult {
        val builder = GetOriginAccessIdentitiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginAccessIdentitiesResultToKotlin(getOriginAccessIdentitiesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information for an Amazon CloudFront origin access identity.
     * ## Example Usage
     * The following example below creates a CloudFront origin access identity.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getOriginAccessIdentity({
     *     id: "E1ZAKK699EOLAL",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_origin_access_identity(id="E1ZAKK699EOLAL")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetOriginAccessIdentity.Invoke(new()
     *     {
     *         Id = "E1ZAKK699EOLAL",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupOriginAccessIdentity(ctx, &cloudfront.LookupOriginAccessIdentityArgs{
     * 			Id: "E1ZAKK699EOLAL",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginAccessIdentity(GetOriginAccessIdentityArgs.builder()
     *             .id("E1ZAKK699EOLAL")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getOriginAccessIdentity
     *       Arguments:
     *         id: E1ZAKK699EOLAL
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOriginAccessIdentity.
     * @return A collection of values returned by getOriginAccessIdentity.
     */
    public suspend fun getOriginAccessIdentity(argument: GetOriginAccessIdentityPlainArgs): GetOriginAccessIdentityResult =
        getOriginAccessIdentityResultToKotlin(getOriginAccessIdentityPlain(argument.toJava()).await())

    /**
     * @see [getOriginAccessIdentity].
     * @param id The identifier for the origin access identity. For example: `E1ZAKK699EOLAL`.
     * @return A collection of values returned by getOriginAccessIdentity.
     */
    public suspend fun getOriginAccessIdentity(id: String): GetOriginAccessIdentityResult {
        val argument = GetOriginAccessIdentityPlainArgs(
            id = id,
        )
        return getOriginAccessIdentityResultToKotlin(getOriginAccessIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginAccessIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginAccessIdentityPlainArgs].
     * @return A collection of values returned by getOriginAccessIdentity.
     */
    public suspend fun getOriginAccessIdentity(argument: suspend GetOriginAccessIdentityPlainArgsBuilder.() -> Unit): GetOriginAccessIdentityResult {
        val builder = GetOriginAccessIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginAccessIdentityResultToKotlin(getOriginAccessIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getOriginRequestPolicy({
     *     name: "example-policy",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_origin_request_policy(name="example-policy")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetOriginRequestPolicy.Invoke(new()
     *     {
     *         Name = "example-policy",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupOriginRequestPolicy(ctx, &cloudfront.LookupOriginRequestPolicyArgs{
     * 			Name: pulumi.StringRef("example-policy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getOriginRequestPolicy(GetOriginRequestPolicyArgs.builder()
     *             .name("example-policy")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getOriginRequestPolicy
     *       Arguments:
     *         name: example-policy
     * ```
     * <!--End PulumiCodeChooser -->
     * ### AWS-Managed Policies
     * AWS managed origin request policy names are prefixed with `Managed-`:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const uaReferer = aws.cloudfront.getOriginRequestPolicy({
     *     name: "Managed-UserAgentRefererHeaders",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ua_referer = aws.cloudfront.get_origin_request_policy(name="Managed-UserAgentRefererHeaders")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var uaReferer = Aws.CloudFront.GetOriginRequestPolicy.Invoke(new()
     *     {
     *         Name = "Managed-UserAgentRefererHeaders",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupOriginRequestPolicy(ctx, &cloudfront.LookupOriginRequestPolicyArgs{
     * 			Name: pulumi.StringRef("Managed-UserAgentRefererHeaders"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetOriginRequestPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var uaReferer = CloudfrontFunctions.getOriginRequestPolicy(GetOriginRequestPolicyArgs.builder()
     *             .name("Managed-UserAgentRefererHeaders")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   uaReferer:
     *     fn::invoke:
     *       Function: aws:cloudfront:getOriginRequestPolicy
     *       Arguments:
     *         name: Managed-UserAgentRefererHeaders
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOriginRequestPolicy.
     * @return A collection of values returned by getOriginRequestPolicy.
     */
    public suspend fun getOriginRequestPolicy(argument: GetOriginRequestPolicyPlainArgs): GetOriginRequestPolicyResult =
        getOriginRequestPolicyResultToKotlin(getOriginRequestPolicyPlain(argument.toJava()).await())

    /**
     * @see [getOriginRequestPolicy].
     * @param id Identifier for the origin request policy.
     * @param name Unique name to identify the origin request policy.
     * @return A collection of values returned by getOriginRequestPolicy.
     */
    public suspend fun getOriginRequestPolicy(id: String? = null, name: String? = null): GetOriginRequestPolicyResult {
        val argument = GetOriginRequestPolicyPlainArgs(
            id = id,
            name = name,
        )
        return getOriginRequestPolicyResultToKotlin(getOriginRequestPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getOriginRequestPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetOriginRequestPolicyPlainArgs].
     * @return A collection of values returned by getOriginRequestPolicy.
     */
    public suspend fun getOriginRequestPolicy(argument: suspend GetOriginRequestPolicyPlainArgsBuilder.() -> Unit): GetOriginRequestPolicyResult {
        val builder = GetOriginRequestPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOriginRequestPolicyResultToKotlin(getOriginRequestPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a CloudFront real-time log configuration resource.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getRealtimeLogConfig({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_realtime_log_config(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetRealtimeLogConfig.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupRealtimeLogConfig(ctx, &cloudfront.LookupRealtimeLogConfigArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetRealtimeLogConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getRealtimeLogConfig(GetRealtimeLogConfigArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getRealtimeLogConfig
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRealtimeLogConfig.
     * @return A collection of values returned by getRealtimeLogConfig.
     */
    public suspend fun getRealtimeLogConfig(argument: GetRealtimeLogConfigPlainArgs): GetRealtimeLogConfigResult =
        getRealtimeLogConfigResultToKotlin(getRealtimeLogConfigPlain(argument.toJava()).await())

    /**
     * @see [getRealtimeLogConfig].
     * @param name Unique name to identify this real-time log configuration.
     * @return A collection of values returned by getRealtimeLogConfig.
     */
    public suspend fun getRealtimeLogConfig(name: String): GetRealtimeLogConfigResult {
        val argument = GetRealtimeLogConfigPlainArgs(
            name = name,
        )
        return getRealtimeLogConfigResultToKotlin(getRealtimeLogConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getRealtimeLogConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetRealtimeLogConfigPlainArgs].
     * @return A collection of values returned by getRealtimeLogConfig.
     */
    public suspend fun getRealtimeLogConfig(argument: suspend GetRealtimeLogConfigPlainArgsBuilder.() -> Unit): GetRealtimeLogConfigResult {
        val builder = GetRealtimeLogConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRealtimeLogConfigResultToKotlin(getRealtimeLogConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to retrieve information about a CloudFront cache policy.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getResponseHeadersPolicy({
     *     name: "example-policy",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_response_headers_policy(name="example-policy")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetResponseHeadersPolicy.Invoke(new()
     *     {
     *         Name = "example-policy",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupResponseHeadersPolicy(ctx, &cloudfront.LookupResponseHeadersPolicyArgs{
     * 			Name: pulumi.StringRef("example-policy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getResponseHeadersPolicy(GetResponseHeadersPolicyArgs.builder()
     *             .name("example-policy")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getResponseHeadersPolicy
     *       Arguments:
     *         name: example-policy
     * ```
     * <!--End PulumiCodeChooser -->
     * ### AWS-Managed Policies
     * AWS managed response header policy names are prefixed with `Managed-`:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cloudfront.getResponseHeadersPolicy({
     *     name: "Managed-SimpleCORS",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cloudfront.get_response_headers_policy(name="Managed-SimpleCORS")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CloudFront.GetResponseHeadersPolicy.Invoke(new()
     *     {
     *         Name = "Managed-SimpleCORS",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cloudfront.LookupResponseHeadersPolicy(ctx, &cloudfront.LookupResponseHeadersPolicyArgs{
     * 			Name: pulumi.StringRef("Managed-SimpleCORS"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudfront.CloudfrontFunctions;
     * import com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudfrontFunctions.getResponseHeadersPolicy(GetResponseHeadersPolicyArgs.builder()
     *             .name("Managed-SimpleCORS")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cloudfront:getResponseHeadersPolicy
     *       Arguments:
     *         name: Managed-SimpleCORS
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResponseHeadersPolicy.
     * @return A collection of values returned by getResponseHeadersPolicy.
     */
    public suspend fun getResponseHeadersPolicy(argument: GetResponseHeadersPolicyPlainArgs): GetResponseHeadersPolicyResult =
        getResponseHeadersPolicyResultToKotlin(getResponseHeadersPolicyPlain(argument.toJava()).await())

    /**
     * @see [getResponseHeadersPolicy].
     * @param id Identifier for the response headers policy.
     * @param name Unique name to identify the response headers policy.
     * @return A collection of values returned by getResponseHeadersPolicy.
     */
    public suspend fun getResponseHeadersPolicy(id: String? = null, name: String? = null): GetResponseHeadersPolicyResult {
        val argument = GetResponseHeadersPolicyPlainArgs(
            id = id,
            name = name,
        )
        return getResponseHeadersPolicyResultToKotlin(getResponseHeadersPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getResponseHeadersPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudfront&#46;kotlin&#46;inputs&#46;GetResponseHeadersPolicyPlainArgs].
     * @return A collection of values returned by getResponseHeadersPolicy.
     */
    public suspend fun getResponseHeadersPolicy(argument: suspend GetResponseHeadersPolicyPlainArgsBuilder.() -> Unit): GetResponseHeadersPolicyResult {
        val builder = GetResponseHeadersPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResponseHeadersPolicyResultToKotlin(getResponseHeadersPolicyPlain(builtArgument.toJava()).await())
    }
}
