@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionCustomErrorResponse
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionDefaultCacheBehavior
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionLoggingConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrderedCacheBehavior
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrigin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginGroup
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionRestrictions
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedKeyGroup
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedSigner
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionViewerCertificate
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionCustomErrorResponse.Companion.toKotlin as distributionCustomErrorResponseToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionDefaultCacheBehavior.Companion.toKotlin as distributionDefaultCacheBehaviorToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionLoggingConfig.Companion.toKotlin as distributionLoggingConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrderedCacheBehavior.Companion.toKotlin as distributionOrderedCacheBehaviorToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOrigin.Companion.toKotlin as distributionOriginToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionOriginGroup.Companion.toKotlin as distributionOriginGroupToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionRestrictions.Companion.toKotlin as distributionRestrictionsToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedKeyGroup.Companion.toKotlin as distributionTrustedKeyGroupToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionTrustedSigner.Companion.toKotlin as distributionTrustedSignerToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.DistributionViewerCertificate.Companion.toKotlin as distributionViewerCertificateToKotlin

/**
 * Builder for [Distribution].
 */
@PulumiTagMarker
public class DistributionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DistributionArgs = DistributionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DistributionArgsBuilder.() -> Unit) {
        val builder = DistributionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Distribution {
        val builtJavaResource = com.pulumi.aws.cloudfront.Distribution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Distribution(builtJavaResource)
    }
}

/**
 * Creates an Amazon CloudFront web distribution.
 * For information about CloudFront distributions, see the [Amazon CloudFront Developer Guide](http://docs&#46;aws&#46;amazon&#46;com/AmazonCloudFront/latest/DeveloperGuide/Introduction&#46;html)&#46; For specific information about creating CloudFront web distributions, see the [POST Distribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html) page in the Amazon CloudFront API Reference.
 * > **NOTE:** CloudFront distributions take about 15 minutes to reach a deployed state after creation or modification. During this time, deletes to resources will be blocked. If you need to delete a distribution that is enabled and you do not want to wait, you need to use the `retain_on_delete` flag.
 * ## Example Usage
 * ### S3 Origin
 * The example below creates a CloudFront distribution with an S3 origin.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const b = new aws.s3.BucketV2("b", {
 *     bucket: "mybucket",
 *     tags: {
 *         Name: "My bucket",
 *     },
 * });
 * const bAcl = new aws.s3.BucketAclV2("b_acl", {
 *     bucket: b.id,
 *     acl: "private",
 * });
 * const s3OriginId = "myS3Origin";
 * const s3Distribution = new aws.cloudfront.Distribution("s3_distribution", {
 *     origins: [{
 *         domainName: b.bucketRegionalDomainName,
 *         originAccessControlId: _default.id,
 *         originId: s3OriginId,
 *     }],
 *     enabled: true,
 *     isIpv6Enabled: true,
 *     comment: "Some comment",
 *     defaultRootObject: "index.html",
 *     loggingConfig: {
 *         includeCookies: false,
 *         bucket: "mylogs.s3.amazonaws.com",
 *         prefix: "myprefix",
 *     },
 *     aliases: [
 *         "mysite.example.com",
 *         "yoursite.example.com",
 *     ],
 *     defaultCacheBehavior: {
 *         allowedMethods: [
 *             "DELETE",
 *             "GET",
 *             "HEAD",
 *             "OPTIONS",
 *             "PATCH",
 *             "POST",
 *             "PUT",
 *         ],
 *         cachedMethods: [
 *             "GET",
 *             "HEAD",
 *         ],
 *         targetOriginId: s3OriginId,
 *         forwardedValues: {
 *             queryString: false,
 *             cookies: {
 *                 forward: "none",
 *             },
 *         },
 *         viewerProtocolPolicy: "allow-all",
 *         minTtl: 0,
 *         defaultTtl: 3600,
 *         maxTtl: 86400,
 *     },
 *     orderedCacheBehaviors: [
 *         {
 *             pathPattern: "/content/immutable/*",
 *             allowedMethods: [
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             ],
 *             cachedMethods: [
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             ],
 *             targetOriginId: s3OriginId,
 *             forwardedValues: {
 *                 queryString: false,
 *                 headers: ["Origin"],
 *                 cookies: {
 *                     forward: "none",
 *                 },
 *             },
 *             minTtl: 0,
 *             defaultTtl: 86400,
 *             maxTtl: 31536000,
 *             compress: true,
 *             viewerProtocolPolicy: "redirect-to-https",
 *         },
 *         {
 *             pathPattern: "/content/*",
 *             allowedMethods: [
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             ],
 *             cachedMethods: [
 *                 "GET",
 *                 "HEAD",
 *             ],
 *             targetOriginId: s3OriginId,
 *             forwardedValues: {
 *                 queryString: false,
 *                 cookies: {
 *                     forward: "none",
 *                 },
 *             },
 *             minTtl: 0,
 *             defaultTtl: 3600,
 *             maxTtl: 86400,
 *             compress: true,
 *             viewerProtocolPolicy: "redirect-to-https",
 *         },
 *     ],
 *     priceClass: "PriceClass_200",
 *     restrictions: {
 *         geoRestriction: {
 *             restrictionType: "whitelist",
 *             locations: [
 *                 "US",
 *                 "CA",
 *                 "GB",
 *                 "DE",
 *             ],
 *         },
 *     },
 *     tags: {
 *         Environment: "production",
 *     },
 *     viewerCertificate: {
 *         cloudfrontDefaultCertificate: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * b = aws.s3.BucketV2("b",
 *     bucket="mybucket",
 *     tags={
 *         "Name": "My bucket",
 *     })
 * b_acl = aws.s3.BucketAclV2("b_acl",
 *     bucket=b.id,
 *     acl="private")
 * s3_origin_id = "myS3Origin"
 * s3_distribution = aws.cloudfront.Distribution("s3_distribution",
 *     origins=[{
 *         "domain_name": b.bucket_regional_domain_name,
 *         "origin_access_control_id": default["id"],
 *         "origin_id": s3_origin_id,
 *     }],
 *     enabled=True,
 *     is_ipv6_enabled=True,
 *     comment="Some comment",
 *     default_root_object="index.html",
 *     logging_config={
 *         "include_cookies": False,
 *         "bucket": "mylogs.s3.amazonaws.com",
 *         "prefix": "myprefix",
 *     },
 *     aliases=[
 *         "mysite.example.com",
 *         "yoursite.example.com",
 *     ],
 *     default_cache_behavior={
 *         "allowed_methods": [
 *             "DELETE",
 *             "GET",
 *             "HEAD",
 *             "OPTIONS",
 *             "PATCH",
 *             "POST",
 *             "PUT",
 *         ],
 *         "cached_methods": [
 *             "GET",
 *             "HEAD",
 *         ],
 *         "target_origin_id": s3_origin_id,
 *         "forwarded_values": {
 *             "query_string": False,
 *             "cookies": {
 *                 "forward": "none",
 *             },
 *         },
 *         "viewer_protocol_policy": "allow-all",
 *         "min_ttl": 0,
 *         "default_ttl": 3600,
 *         "max_ttl": 86400,
 *     },
 *     ordered_cache_behaviors=[
 *         {
 *             "path_pattern": "/content/immutable/*",
 *             "allowed_methods": [
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             ],
 *             "cached_methods": [
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             ],
 *             "target_origin_id": s3_origin_id,
 *             "forwarded_values": {
 *                 "query_string": False,
 *                 "headers": ["Origin"],
 *                 "cookies": {
 *                     "forward": "none",
 *                 },
 *             },
 *             "min_ttl": 0,
 *             "default_ttl": 86400,
 *             "max_ttl": 31536000,
 *             "compress": True,
 *             "viewer_protocol_policy": "redirect-to-https",
 *         },
 *         {
 *             "path_pattern": "/content/*",
 *             "allowed_methods": [
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             ],
 *             "cached_methods": [
 *                 "GET",
 *                 "HEAD",
 *             ],
 *             "target_origin_id": s3_origin_id,
 *             "forwarded_values": {
 *                 "query_string": False,
 *                 "cookies": {
 *                     "forward": "none",
 *                 },
 *             },
 *             "min_ttl": 0,
 *             "default_ttl": 3600,
 *             "max_ttl": 86400,
 *             "compress": True,
 *             "viewer_protocol_policy": "redirect-to-https",
 *         },
 *     ],
 *     price_class="PriceClass_200",
 *     restrictions={
 *         "geo_restriction": {
 *             "restriction_type": "whitelist",
 *             "locations": [
 *                 "US",
 *                 "CA",
 *                 "GB",
 *                 "DE",
 *             ],
 *         },
 *     },
 *     tags={
 *         "Environment": "production",
 *     },
 *     viewer_certificate={
 *         "cloudfront_default_certificate": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var b = new Aws.S3.BucketV2("b", new()
 *     {
 *         Bucket = "mybucket",
 *         Tags =
 *         {
 *             { "Name", "My bucket" },
 *         },
 *     });
 *     var bAcl = new Aws.S3.BucketAclV2("b_acl", new()
 *     {
 *         Bucket = b.Id,
 *         Acl = "private",
 *     });
 *     var s3OriginId = "myS3Origin";
 *     var s3Distribution = new Aws.CloudFront.Distribution("s3_distribution", new()
 *     {
 *         Origins = new[]
 *         {
 *             new Aws.CloudFront.Inputs.DistributionOriginArgs
 *             {
 *                 DomainName = b.BucketRegionalDomainName,
 *                 OriginAccessControlId = @default.Id,
 *                 OriginId = s3OriginId,
 *             },
 *         },
 *         Enabled = true,
 *         IsIpv6Enabled = true,
 *         Comment = "Some comment",
 *         DefaultRootObject = "index.html",
 *         LoggingConfig = new Aws.CloudFront.Inputs.DistributionLoggingConfigArgs
 *         {
 *             IncludeCookies = false,
 *             Bucket = "mylogs.s3.amazonaws.com",
 *             Prefix = "myprefix",
 *         },
 *         Aliases = new[]
 *         {
 *             "mysite.example.com",
 *             "yoursite.example.com",
 *         },
 *         DefaultCacheBehavior = new Aws.CloudFront.Inputs.DistributionDefaultCacheBehaviorArgs
 *         {
 *             AllowedMethods = new[]
 *             {
 *                 "DELETE",
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *                 "PATCH",
 *                 "POST",
 *                 "PUT",
 *             },
 *             CachedMethods = new[]
 *             {
 *                 "GET",
 *                 "HEAD",
 *             },
 *             TargetOriginId = s3OriginId,
 *             ForwardedValues = new Aws.CloudFront.Inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs
 *             {
 *                 QueryString = false,
 *                 Cookies = new Aws.CloudFront.Inputs.DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs
 *                 {
 *                     Forward = "none",
 *                 },
 *             },
 *             ViewerProtocolPolicy = "allow-all",
 *             MinTtl = 0,
 *             DefaultTtl = 3600,
 *             MaxTtl = 86400,
 *         },
 *         OrderedCacheBehaviors = new[]
 *         {
 *             new Aws.CloudFront.Inputs.DistributionOrderedCacheBehaviorArgs
 *             {
 *                 PathPattern = "/content/immutable/*",
 *                 AllowedMethods = new[]
 *                 {
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS",
 *                 },
 *                 CachedMethods = new[]
 *                 {
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS",
 *                 },
 *                 TargetOriginId = s3OriginId,
 *                 ForwardedValues = new Aws.CloudFront.Inputs.DistributionOrderedCacheBehaviorForwardedValuesArgs
 *                 {
 *                     QueryString = false,
 *                     Headers = new[]
 *                     {
 *                         "Origin",
 *                     },
 *                     Cookies = new Aws.CloudFront.Inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs
 *                     {
 *                         Forward = "none",
 *                     },
 *                 },
 *                 MinTtl = 0,
 *                 DefaultTtl = 86400,
 *                 MaxTtl = 31536000,
 *                 Compress = true,
 *                 ViewerProtocolPolicy = "redirect-to-https",
 *             },
 *             new Aws.CloudFront.Inputs.DistributionOrderedCacheBehaviorArgs
 *             {
 *                 PathPattern = "/content/*",
 *                 AllowedMethods = new[]
 *                 {
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS",
 *                 },
 *                 CachedMethods = new[]
 *                 {
 *                     "GET",
 *                     "HEAD",
 *                 },
 *                 TargetOriginId = s3OriginId,
 *                 ForwardedValues = new Aws.CloudFront.Inputs.DistributionOrderedCacheBehaviorForwardedValuesArgs
 *                 {
 *                     QueryString = false,
 *                     Cookies = new Aws.CloudFront.Inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs
 *                     {
 *                         Forward = "none",
 *                     },
 *                 },
 *                 MinTtl = 0,
 *                 DefaultTtl = 3600,
 *                 MaxTtl = 86400,
 *                 Compress = true,
 *                 ViewerProtocolPolicy = "redirect-to-https",
 *             },
 *         },
 *         PriceClass = "PriceClass_200",
 *         Restrictions = new Aws.CloudFront.Inputs.DistributionRestrictionsArgs
 *         {
 *             GeoRestriction = new Aws.CloudFront.Inputs.DistributionRestrictionsGeoRestrictionArgs
 *             {
 *                 RestrictionType = "whitelist",
 *                 Locations = new[]
 *                 {
 *                     "US",
 *                     "CA",
 *                     "GB",
 *                     "DE",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *         },
 *         ViewerCertificate = new Aws.CloudFront.Inputs.DistributionViewerCertificateArgs
 *         {
 *             CloudfrontDefaultCertificate = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		b, err := s3.NewBucketV2(ctx, "b", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("mybucket"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("My bucket"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "b_acl", &s3.BucketAclV2Args{
 * 			Bucket: b.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		s3OriginId := "myS3Origin"
 * 		_, err = cloudfront.NewDistribution(ctx, "s3_distribution", &cloudfront.DistributionArgs{
 * 			Origins: cloudfront.DistributionOriginArray{
 * 				&cloudfront.DistributionOriginArgs{
 * 					DomainName:            b.BucketRegionalDomainName,
 * 					OriginAccessControlId: pulumi.Any(_default.Id),
 * 					OriginId:              pulumi.String(s3OriginId),
 * 				},
 * 			},
 * 			Enabled:           pulumi.Bool(true),
 * 			IsIpv6Enabled:     pulumi.Bool(true),
 * 			Comment:           pulumi.String("Some comment"),
 * 			DefaultRootObject: pulumi.String("index.html"),
 * 			LoggingConfig: &cloudfront.DistributionLoggingConfigArgs{
 * 				IncludeCookies: pulumi.Bool(false),
 * 				Bucket:         pulumi.String("mylogs.s3.amazonaws.com"),
 * 				Prefix:         pulumi.String("myprefix"),
 * 			},
 * 			Aliases: pulumi.StringArray{
 * 				pulumi.String("mysite.example.com"),
 * 				pulumi.String("yoursite.example.com"),
 * 			},
 * 			DefaultCacheBehavior: &cloudfront.DistributionDefaultCacheBehaviorArgs{
 * 				AllowedMethods: pulumi.StringArray{
 * 					pulumi.String("DELETE"),
 * 					pulumi.String("GET"),
 * 					pulumi.String("HEAD"),
 * 					pulumi.String("OPTIONS"),
 * 					pulumi.String("PATCH"),
 * 					pulumi.String("POST"),
 * 					pulumi.String("PUT"),
 * 				},
 * 				CachedMethods: pulumi.StringArray{
 * 					pulumi.String("GET"),
 * 					pulumi.String("HEAD"),
 * 				},
 * 				TargetOriginId: pulumi.String(s3OriginId),
 * 				ForwardedValues: &cloudfront.DistributionDefaultCacheBehaviorForwardedValuesArgs{
 * 					QueryString: pulumi.Bool(false),
 * 					Cookies: &cloudfront.DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs{
 * 						Forward: pulumi.String("none"),
 * 					},
 * 				},
 * 				ViewerProtocolPolicy: pulumi.String("allow-all"),
 * 				MinTtl:               pulumi.Int(0),
 * 				DefaultTtl:           pulumi.Int(3600),
 * 				MaxTtl:               pulumi.Int(86400),
 * 			},
 * 			OrderedCacheBehaviors: cloudfront.DistributionOrderedCacheBehaviorArray{
 * 				&cloudfront.DistributionOrderedCacheBehaviorArgs{
 * 					PathPattern: pulumi.String("/content/immutable/*"),
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 						pulumi.String("HEAD"),
 * 						pulumi.String("OPTIONS"),
 * 					},
 * 					CachedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 						pulumi.String("HEAD"),
 * 						pulumi.String("OPTIONS"),
 * 					},
 * 					TargetOriginId: pulumi.String(s3OriginId),
 * 					ForwardedValues: &cloudfront.DistributionOrderedCacheBehaviorForwardedValuesArgs{
 * 						QueryString: pulumi.Bool(false),
 * 						Headers: pulumi.StringArray{
 * 							pulumi.String("Origin"),
 * 						},
 * 						Cookies: &cloudfront.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs{
 * 							Forward: pulumi.String("none"),
 * 						},
 * 					},
 * 					MinTtl:               pulumi.Int(0),
 * 					DefaultTtl:           pulumi.Int(86400),
 * 					MaxTtl:               pulumi.Int(31536000),
 * 					Compress:             pulumi.Bool(true),
 * 					ViewerProtocolPolicy: pulumi.String("redirect-to-https"),
 * 				},
 * 				&cloudfront.DistributionOrderedCacheBehaviorArgs{
 * 					PathPattern: pulumi.String("/content/*"),
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 						pulumi.String("HEAD"),
 * 						pulumi.String("OPTIONS"),
 * 					},
 * 					CachedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 						pulumi.String("HEAD"),
 * 					},
 * 					TargetOriginId: pulumi.String(s3OriginId),
 * 					ForwardedValues: &cloudfront.DistributionOrderedCacheBehaviorForwardedValuesArgs{
 * 						QueryString: pulumi.Bool(false),
 * 						Cookies: &cloudfront.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs{
 * 							Forward: pulumi.String("none"),
 * 						},
 * 					},
 * 					MinTtl:               pulumi.Int(0),
 * 					DefaultTtl:           pulumi.Int(3600),
 * 					MaxTtl:               pulumi.Int(86400),
 * 					Compress:             pulumi.Bool(true),
 * 					ViewerProtocolPolicy: pulumi.String("redirect-to-https"),
 * 				},
 * 			},
 * 			PriceClass: pulumi.String("PriceClass_200"),
 * 			Restrictions: &cloudfront.DistributionRestrictionsArgs{
 * 				GeoRestriction: &cloudfront.DistributionRestrictionsGeoRestrictionArgs{
 * 					RestrictionType: pulumi.String("whitelist"),
 * 					Locations: pulumi.StringArray{
 * 						pulumi.String("US"),
 * 						pulumi.String("CA"),
 * 						pulumi.String("GB"),
 * 						pulumi.String("DE"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("production"),
 * 			},
 * 			ViewerCertificate: &cloudfront.DistributionViewerCertificateArgs{
 * 				CloudfrontDefaultCertificate: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionLoggingConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionViewerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var b = new BucketV2("b", BucketV2Args.builder()
 *             .bucket("mybucket")
 *             .tags(Map.of("Name", "My bucket"))
 *             .build());
 *         var bAcl = new BucketAclV2("bAcl", BucketAclV2Args.builder()
 *             .bucket(b.id())
 *             .acl("private")
 *             .build());
 *         final var s3OriginId = "myS3Origin";
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .domainName(b.bucketRegionalDomainName())
 *                 .originAccessControlId(default_.id())
 *                 .originId(s3OriginId)
 *                 .build())
 *             .enabled(true)
 *             .isIpv6Enabled(true)
 *             .comment("Some comment")
 *             .defaultRootObject("index.html")
 *             .loggingConfig(DistributionLoggingConfigArgs.builder()
 *                 .includeCookies(false)
 *                 .bucket("mylogs.s3.amazonaws.com")
 *                 .prefix("myprefix")
 *                 .build())
 *             .aliases(
 *                 "mysite.example.com",
 *                 "yoursite.example.com")
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .allowedMethods(
 *                     "DELETE",
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS",
 *                     "PATCH",
 *                     "POST",
 *                     "PUT")
 *                 .cachedMethods(
 *                     "GET",
 *                     "HEAD")
 *                 .targetOriginId(s3OriginId)
 *                 .forwardedValues(DistributionDefaultCacheBehaviorForwardedValuesArgs.builder()
 *                     .queryString(false)
 *                     .cookies(DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                         .forward("none")
 *                         .build())
 *                     .build())
 *                 .viewerProtocolPolicy("allow-all")
 *                 .minTtl(0)
 *                 .defaultTtl(3600)
 *                 .maxTtl(86400)
 *                 .build())
 *             .orderedCacheBehaviors(
 *                 DistributionOrderedCacheBehaviorArgs.builder()
 *                     .pathPattern("/content/immutable/*")
 *                     .allowedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .cachedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .targetOriginId(s3OriginId)
 *                     .forwardedValues(DistributionOrderedCacheBehaviorForwardedValuesArgs.builder()
 *                         .queryString(false)
 *                         .headers("Origin")
 *                         .cookies(DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                             .forward("none")
 *                             .build())
 *                         .build())
 *                     .minTtl(0)
 *                     .defaultTtl(86400)
 *                     .maxTtl(31536000)
 *                     .compress(true)
 *                     .viewerProtocolPolicy("redirect-to-https")
 *                     .build(),
 *                 DistributionOrderedCacheBehaviorArgs.builder()
 *                     .pathPattern("/content/*")
 *                     .allowedMethods(
 *                         "GET",
 *                         "HEAD",
 *                         "OPTIONS")
 *                     .cachedMethods(
 *                         "GET",
 *                         "HEAD")
 *                     .targetOriginId(s3OriginId)
 *                     .forwardedValues(DistributionOrderedCacheBehaviorForwardedValuesArgs.builder()
 *                         .queryString(false)
 *                         .cookies(DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
 *                             .forward("none")
 *                             .build())
 *                         .build())
 *                     .minTtl(0)
 *                     .defaultTtl(3600)
 *                     .maxTtl(86400)
 *                     .compress(true)
 *                     .viewerProtocolPolicy("redirect-to-https")
 *                     .build())
 *             .priceClass("PriceClass_200")
 *             .restrictions(DistributionRestrictionsArgs.builder()
 *                 .geoRestriction(DistributionRestrictionsGeoRestrictionArgs.builder()
 *                     .restrictionType("whitelist")
 *                     .locations(
 *                         "US",
 *                         "CA",
 *                         "GB",
 *                         "DE")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "production"))
 *             .viewerCertificate(DistributionViewerCertificateArgs.builder()
 *                 .cloudfrontDefaultCertificate(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   b:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: mybucket
 *       tags:
 *         Name: My bucket
 *   bAcl:
 *     type: aws:s3:BucketAclV2
 *     name: b_acl
 *     properties:
 *       bucket: ${b.id}
 *       acl: private
 *   s3Distribution:
 *     type: aws:cloudfront:Distribution
 *     name: s3_distribution
 *     properties:
 *       origins:
 *         - domainName: ${b.bucketRegionalDomainName}
 *           originAccessControlId: ${default.id}
 *           originId: ${s3OriginId}
 *       enabled: true
 *       isIpv6Enabled: true
 *       comment: Some comment
 *       defaultRootObject: index.html
 *       loggingConfig:
 *         includeCookies: false
 *         bucket: mylogs.s3.amazonaws.com
 *         prefix: myprefix
 *       aliases:
 *         - mysite.example.com
 *         - yoursite.example.com
 *       defaultCacheBehavior:
 *         allowedMethods:
 *           - DELETE
 *           - GET
 *           - HEAD
 *           - OPTIONS
 *           - PATCH
 *           - POST
 *           - PUT
 *         cachedMethods:
 *           - GET
 *           - HEAD
 *         targetOriginId: ${s3OriginId}
 *         forwardedValues:
 *           queryString: false
 *           cookies:
 *             forward: none
 *         viewerProtocolPolicy: allow-all
 *         minTtl: 0
 *         defaultTtl: 3600
 *         maxTtl: 86400
 *       orderedCacheBehaviors:
 *         - pathPattern: /content/immutable/*
 *           allowedMethods:
 *             - GET
 *             - HEAD
 *             - OPTIONS
 *           cachedMethods:
 *             - GET
 *             - HEAD
 *             - OPTIONS
 *           targetOriginId: ${s3OriginId}
 *           forwardedValues:
 *             queryString: false
 *             headers:
 *               - Origin
 *             cookies:
 *               forward: none
 *           minTtl: 0
 *           defaultTtl: 86400
 *           maxTtl: 3.1536e+07
 *           compress: true
 *           viewerProtocolPolicy: redirect-to-https
 *         - pathPattern: /content/*
 *           allowedMethods:
 *             - GET
 *             - HEAD
 *             - OPTIONS
 *           cachedMethods:
 *             - GET
 *             - HEAD
 *           targetOriginId: ${s3OriginId}
 *           forwardedValues:
 *             queryString: false
 *             cookies:
 *               forward: none
 *           minTtl: 0
 *           defaultTtl: 3600
 *           maxTtl: 86400
 *           compress: true
 *           viewerProtocolPolicy: redirect-to-https
 *       priceClass: PriceClass_200
 *       restrictions:
 *         geoRestriction:
 *           restrictionType: whitelist
 *           locations:
 *             - US
 *             - CA
 *             - GB
 *             - DE
 *       tags:
 *         Environment: production
 *       viewerCertificate:
 *         cloudfrontDefaultCertificate: true
 * variables:
 *   s3OriginId: myS3Origin
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Failover Routing
 * The example below creates a CloudFront distribution with an origin group for failover routing.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const s3Distribution = new aws.cloudfront.Distribution("s3_distribution", {
 *     originGroups: [{
 *         originId: "groupS3",
 *         failoverCriteria: {
 *             statusCodes: [
 *                 403,
 *                 404,
 *                 500,
 *                 502,
 *             ],
 *         },
 *         members: [
 *             {
 *                 originId: "primaryS3",
 *             },
 *             {
 *                 originId: "failoverS3",
 *             },
 *         ],
 *     }],
 *     origins: [
 *         {
 *             domainName: primary.bucketRegionalDomainName,
 *             originId: "primaryS3",
 *             s3OriginConfig: {
 *                 originAccessIdentity: _default.cloudfrontAccessIdentityPath,
 *             },
 *         },
 *         {
 *             domainName: failover.bucketRegionalDomainName,
 *             originId: "failoverS3",
 *             s3OriginConfig: {
 *                 originAccessIdentity: _default.cloudfrontAccessIdentityPath,
 *             },
 *         },
 *     ],
 *     defaultCacheBehavior: {
 *         targetOriginId: "groupS3",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * s3_distribution = aws.cloudfront.Distribution("s3_distribution",
 *     origin_groups=[{
 *         "origin_id": "groupS3",
 *         "failover_criteria": {
 *             "status_codes": [
 *                 403,
 *                 404,
 *                 500,
 *                 502,
 *             ],
 *         },
 *         "members": [
 *             {
 *                 "origin_id": "primaryS3",
 *             },
 *             {
 *                 "origin_id": "failoverS3",
 *             },
 *         ],
 *     }],
 *     origins=[
 *         {
 *             "domain_name": primary["bucketRegionalDomainName"],
 *             "origin_id": "primaryS3",
 *             "s3_origin_config": {
 *                 "origin_access_identity": default["cloudfrontAccessIdentityPath"],
 *             },
 *         },
 *         {
 *             "domain_name": failover["bucketRegionalDomainName"],
 *             "origin_id": "failoverS3",
 *             "s3_origin_config": {
 *                 "origin_access_identity": default["cloudfrontAccessIdentityPath"],
 *             },
 *         },
 *     ],
 *     default_cache_behavior={
 *         "target_origin_id": "groupS3",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var s3Distribution = new Aws.CloudFront.Distribution("s3_distribution", new()
 *     {
 *         OriginGroups = new[]
 *         {
 *             new Aws.CloudFront.Inputs.DistributionOriginGroupArgs
 *             {
 *                 OriginId = "groupS3",
 *                 FailoverCriteria = new Aws.CloudFront.Inputs.DistributionOriginGroupFailoverCriteriaArgs
 *                 {
 *                     StatusCodes = new[]
 *                     {
 *                         403,
 *                         404,
 *                         500,
 *                         502,
 *                     },
 *                 },
 *                 Members = new[]
 *                 {
 *                     new Aws.CloudFront.Inputs.DistributionOriginGroupMemberArgs
 *                     {
 *                         OriginId = "primaryS3",
 *                     },
 *                     new Aws.CloudFront.Inputs.DistributionOriginGroupMemberArgs
 *                     {
 *                         OriginId = "failoverS3",
 *                     },
 *                 },
 *             },
 *         },
 *         Origins = new[]
 *         {
 *             new Aws.CloudFront.Inputs.DistributionOriginArgs
 *             {
 *                 DomainName = primary.BucketRegionalDomainName,
 *                 OriginId = "primaryS3",
 *                 S3OriginConfig = new Aws.CloudFront.Inputs.DistributionOriginS3OriginConfigArgs
 *                 {
 *                     OriginAccessIdentity = @default.CloudfrontAccessIdentityPath,
 *                 },
 *             },
 *             new Aws.CloudFront.Inputs.DistributionOriginArgs
 *             {
 *                 DomainName = failover.BucketRegionalDomainName,
 *                 OriginId = "failoverS3",
 *                 S3OriginConfig = new Aws.CloudFront.Inputs.DistributionOriginS3OriginConfigArgs
 *                 {
 *                     OriginAccessIdentity = @default.CloudfrontAccessIdentityPath,
 *                 },
 *             },
 *         },
 *         DefaultCacheBehavior = new Aws.CloudFront.Inputs.DistributionDefaultCacheBehaviorArgs
 *         {
 *             TargetOriginId = "groupS3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewDistribution(ctx, "s3_distribution", &cloudfront.DistributionArgs{
 * 			OriginGroups: cloudfront.DistributionOriginGroupArray{
 * 				&cloudfront.DistributionOriginGroupArgs{
 * 					OriginId: pulumi.String("groupS3"),
 * 					FailoverCriteria: &cloudfront.DistributionOriginGroupFailoverCriteriaArgs{
 * 						StatusCodes: pulumi.IntArray{
 * 							pulumi.Int(403),
 * 							pulumi.Int(404),
 * 							pulumi.Int(500),
 * 							pulumi.Int(502),
 * 						},
 * 					},
 * 					Members: cloudfront.DistributionOriginGroupMemberArray{
 * 						&cloudfront.DistributionOriginGroupMemberArgs{
 * 							OriginId: pulumi.String("primaryS3"),
 * 						},
 * 						&cloudfront.DistributionOriginGroupMemberArgs{
 * 							OriginId: pulumi.String("failoverS3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Origins: cloudfront.DistributionOriginArray{
 * 				&cloudfront.DistributionOriginArgs{
 * 					DomainName: pulumi.Any(primary.BucketRegionalDomainName),
 * 					OriginId:   pulumi.String("primaryS3"),
 * 					S3OriginConfig: &cloudfront.DistributionOriginS3OriginConfigArgs{
 * 						OriginAccessIdentity: pulumi.Any(_default.CloudfrontAccessIdentityPath),
 * 					},
 * 				},
 * 				&cloudfront.DistributionOriginArgs{
 * 					DomainName: pulumi.Any(failover.BucketRegionalDomainName),
 * 					OriginId:   pulumi.String("failoverS3"),
 * 					S3OriginConfig: &cloudfront.DistributionOriginS3OriginConfigArgs{
 * 						OriginAccessIdentity: pulumi.Any(_default.CloudfrontAccessIdentityPath),
 * 					},
 * 				},
 * 			},
 * 			DefaultCacheBehavior: &cloudfront.DistributionDefaultCacheBehaviorArgs{
 * 				TargetOriginId: pulumi.String("groupS3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupFailoverCriteriaArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .originGroups(DistributionOriginGroupArgs.builder()
 *                 .originId("groupS3")
 *                 .failoverCriteria(DistributionOriginGroupFailoverCriteriaArgs.builder()
 *                     .statusCodes(
 *                         403,
 *                         404,
 *                         500,
 *                         502)
 *                     .build())
 *                 .members(
 *                     DistributionOriginGroupMemberArgs.builder()
 *                         .originId("primaryS3")
 *                         .build(),
 *                     DistributionOriginGroupMemberArgs.builder()
 *                         .originId("failoverS3")
 *                         .build())
 *                 .build())
 *             .origins(
 *                 DistributionOriginArgs.builder()
 *                     .domainName(primary.bucketRegionalDomainName())
 *                     .originId("primaryS3")
 *                     .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                         .originAccessIdentity(default_.cloudfrontAccessIdentityPath())
 *                         .build())
 *                     .build(),
 *                 DistributionOriginArgs.builder()
 *                     .domainName(failover.bucketRegionalDomainName())
 *                     .originId("failoverS3")
 *                     .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                         .originAccessIdentity(default_.cloudfrontAccessIdentityPath())
 *                         .build())
 *                     .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .targetOriginId("groupS3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   s3Distribution:
 *     type: aws:cloudfront:Distribution
 *     name: s3_distribution
 *     properties:
 *       originGroups:
 *         - originId: groupS3
 *           failoverCriteria:
 *             statusCodes:
 *               - 403
 *               - 404
 *               - 500
 *               - 502
 *           members:
 *             - originId: primaryS3
 *             - originId: failoverS3
 *       origins:
 *         - domainName: ${primary.bucketRegionalDomainName}
 *           originId: primaryS3
 *           s3OriginConfig:
 *             originAccessIdentity: ${default.cloudfrontAccessIdentityPath}
 *         - domainName: ${failover.bucketRegionalDomainName}
 *           originId: failoverS3
 *           s3OriginConfig:
 *             originAccessIdentity: ${default.cloudfrontAccessIdentityPath}
 *       defaultCacheBehavior:
 *         targetOriginId: groupS3
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Managed Caching Policy
 * The example below creates a CloudFront distribution with an [AWS managed caching policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const s3OriginId = "myS3Origin";
 * const s3Distribution = new aws.cloudfront.Distribution("s3_distribution", {
 *     origins: [{
 *         domainName: primary.bucketRegionalDomainName,
 *         originId: "myS3Origin",
 *         s3OriginConfig: {
 *             originAccessIdentity: _default.cloudfrontAccessIdentityPath,
 *         },
 *     }],
 *     enabled: true,
 *     isIpv6Enabled: true,
 *     comment: "Some comment",
 *     defaultRootObject: "index.html",
 *     defaultCacheBehavior: {
 *         cachePolicyId: "4135ea2d-6df8-44a3-9df3-4b5a84be39ad",
 *         allowedMethods: [
 *             "GET",
 *             "HEAD",
 *             "OPTIONS",
 *         ],
 *         targetOriginId: s3OriginId,
 *     },
 *     restrictions: {
 *         geoRestriction: {
 *             restrictionType: "whitelist",
 *             locations: [
 *                 "US",
 *                 "CA",
 *                 "GB",
 *                 "DE",
 *             ],
 *         },
 *     },
 *     viewerCertificate: {
 *         cloudfrontDefaultCertificate: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * s3_origin_id = "myS3Origin"
 * s3_distribution = aws.cloudfront.Distribution("s3_distribution",
 *     origins=[{
 *         "domain_name": primary["bucketRegionalDomainName"],
 *         "origin_id": "myS3Origin",
 *         "s3_origin_config": {
 *             "origin_access_identity": default["cloudfrontAccessIdentityPath"],
 *         },
 *     }],
 *     enabled=True,
 *     is_ipv6_enabled=True,
 *     comment="Some comment",
 *     default_root_object="index.html",
 *     default_cache_behavior={
 *         "cache_policy_id": "4135ea2d-6df8-44a3-9df3-4b5a84be39ad",
 *         "allowed_methods": [
 *             "GET",
 *             "HEAD",
 *             "OPTIONS",
 *         ],
 *         "target_origin_id": s3_origin_id,
 *     },
 *     restrictions={
 *         "geo_restriction": {
 *             "restriction_type": "whitelist",
 *             "locations": [
 *                 "US",
 *                 "CA",
 *                 "GB",
 *                 "DE",
 *             ],
 *         },
 *     },
 *     viewer_certificate={
 *         "cloudfront_default_certificate": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var s3OriginId = "myS3Origin";
 *     var s3Distribution = new Aws.CloudFront.Distribution("s3_distribution", new()
 *     {
 *         Origins = new[]
 *         {
 *             new Aws.CloudFront.Inputs.DistributionOriginArgs
 *             {
 *                 DomainName = primary.BucketRegionalDomainName,
 *                 OriginId = "myS3Origin",
 *                 S3OriginConfig = new Aws.CloudFront.Inputs.DistributionOriginS3OriginConfigArgs
 *                 {
 *                     OriginAccessIdentity = @default.CloudfrontAccessIdentityPath,
 *                 },
 *             },
 *         },
 *         Enabled = true,
 *         IsIpv6Enabled = true,
 *         Comment = "Some comment",
 *         DefaultRootObject = "index.html",
 *         DefaultCacheBehavior = new Aws.CloudFront.Inputs.DistributionDefaultCacheBehaviorArgs
 *         {
 *             CachePolicyId = "4135ea2d-6df8-44a3-9df3-4b5a84be39ad",
 *             AllowedMethods = new[]
 *             {
 *                 "GET",
 *                 "HEAD",
 *                 "OPTIONS",
 *             },
 *             TargetOriginId = s3OriginId,
 *         },
 *         Restrictions = new Aws.CloudFront.Inputs.DistributionRestrictionsArgs
 *         {
 *             GeoRestriction = new Aws.CloudFront.Inputs.DistributionRestrictionsGeoRestrictionArgs
 *             {
 *                 RestrictionType = "whitelist",
 *                 Locations = new[]
 *                 {
 *                     "US",
 *                     "CA",
 *                     "GB",
 *                     "DE",
 *                 },
 *             },
 *         },
 *         ViewerCertificate = new Aws.CloudFront.Inputs.DistributionViewerCertificateArgs
 *         {
 *             CloudfrontDefaultCertificate = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		s3OriginId := "myS3Origin"
 * 		_, err := cloudfront.NewDistribution(ctx, "s3_distribution", &cloudfront.DistributionArgs{
 * 			Origins: cloudfront.DistributionOriginArray{
 * 				&cloudfront.DistributionOriginArgs{
 * 					DomainName: pulumi.Any(primary.BucketRegionalDomainName),
 * 					OriginId:   pulumi.String("myS3Origin"),
 * 					S3OriginConfig: &cloudfront.DistributionOriginS3OriginConfigArgs{
 * 						OriginAccessIdentity: pulumi.Any(_default.CloudfrontAccessIdentityPath),
 * 					},
 * 				},
 * 			},
 * 			Enabled:           pulumi.Bool(true),
 * 			IsIpv6Enabled:     pulumi.Bool(true),
 * 			Comment:           pulumi.String("Some comment"),
 * 			DefaultRootObject: pulumi.String("index.html"),
 * 			DefaultCacheBehavior: &cloudfront.DistributionDefaultCacheBehaviorArgs{
 * 				CachePolicyId: pulumi.String("4135ea2d-6df8-44a3-9df3-4b5a84be39ad"),
 * 				AllowedMethods: pulumi.StringArray{
 * 					pulumi.String("GET"),
 * 					pulumi.String("HEAD"),
 * 					pulumi.String("OPTIONS"),
 * 				},
 * 				TargetOriginId: pulumi.String(s3OriginId),
 * 			},
 * 			Restrictions: &cloudfront.DistributionRestrictionsArgs{
 * 				GeoRestriction: &cloudfront.DistributionRestrictionsGeoRestrictionArgs{
 * 					RestrictionType: pulumi.String("whitelist"),
 * 					Locations: pulumi.StringArray{
 * 						pulumi.String("US"),
 * 						pulumi.String("CA"),
 * 						pulumi.String("GB"),
 * 						pulumi.String("DE"),
 * 					},
 * 				},
 * 			},
 * 			ViewerCertificate: &cloudfront.DistributionViewerCertificateArgs{
 * 				CloudfrontDefaultCertificate: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.Distribution;
 * import com.pulumi.aws.cloudfront.DistributionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionOriginS3OriginConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs;
 * import com.pulumi.aws.cloudfront.inputs.DistributionViewerCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var s3OriginId = "myS3Origin";
 *         var s3Distribution = new Distribution("s3Distribution", DistributionArgs.builder()
 *             .origins(DistributionOriginArgs.builder()
 *                 .domainName(primary.bucketRegionalDomainName())
 *                 .originId("myS3Origin")
 *                 .s3OriginConfig(DistributionOriginS3OriginConfigArgs.builder()
 *                     .originAccessIdentity(default_.cloudfrontAccessIdentityPath())
 *                     .build())
 *                 .build())
 *             .enabled(true)
 *             .isIpv6Enabled(true)
 *             .comment("Some comment")
 *             .defaultRootObject("index.html")
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .cachePolicyId("4135ea2d-6df8-44a3-9df3-4b5a84be39ad")
 *                 .allowedMethods(
 *                     "GET",
 *                     "HEAD",
 *                     "OPTIONS")
 *                 .targetOriginId(s3OriginId)
 *                 .build())
 *             .restrictions(DistributionRestrictionsArgs.builder()
 *                 .geoRestriction(DistributionRestrictionsGeoRestrictionArgs.builder()
 *                     .restrictionType("whitelist")
 *                     .locations(
 *                         "US",
 *                         "CA",
 *                         "GB",
 *                         "DE")
 *                     .build())
 *                 .build())
 *             .viewerCertificate(DistributionViewerCertificateArgs.builder()
 *                 .cloudfrontDefaultCertificate(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   s3Distribution:
 *     type: aws:cloudfront:Distribution
 *     name: s3_distribution
 *     properties:
 *       origins:
 *         - domainName: ${primary.bucketRegionalDomainName}
 *           originId: myS3Origin
 *           s3OriginConfig:
 *             originAccessIdentity: ${default.cloudfrontAccessIdentityPath}
 *       enabled: true
 *       isIpv6Enabled: true
 *       comment: Some comment
 *       defaultRootObject: index.html
 *       defaultCacheBehavior:
 *         cachePolicyId: 4135ea2d-6df8-44a3-9df3-4b5a84be39ad
 *         allowedMethods:
 *           - GET
 *           - HEAD
 *           - OPTIONS
 *         targetOriginId: ${s3OriginId}
 *       restrictions:
 *         geoRestriction:
 *           restrictionType: whitelist
 *           locations:
 *             - US
 *             - CA
 *             - GB
 *             - DE
 *       viewerCertificate:
 *         cloudfrontDefaultCertificate: true
 * variables:
 *   s3OriginId: myS3Origin
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Distributions using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/distribution:Distribution distribution E74FTE3EXAMPLE
 * ```
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public class Distribution internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.Distribution,
) : KotlinCustomResource(javaResource, DistributionMapper) {
    public val aliases: Output<List<String>>?
        get() = javaResource.aliases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * ARN for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your AWS account ID.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Internal value used by CloudFront to allow future updates to the distribution configuration.
     */
    public val callerReference: Output<String>
        get() = javaResource.callerReference().applyValue({ args0 -> args0 })

    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val continuousDeploymentPolicyId: Output<String>
        get() = javaResource.continuousDeploymentPolicyId().applyValue({ args0 -> args0 })

    public val customErrorResponses: Output<List<DistributionCustomErrorResponse>>?
        get() = javaResource.customErrorResponses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        distributionCustomErrorResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val defaultCacheBehavior: Output<DistributionDefaultCacheBehavior>
        get() = javaResource.defaultCacheBehavior().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionDefaultCacheBehaviorToKotlin(args0)
            })
        })

    public val defaultRootObject: Output<String>?
        get() = javaResource.defaultRootObject().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain name corresponding to the distribution. For example: `d604721fxaaqy9.cloudfront.net`.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * `true` if any of the AWS accounts listed as trusted signers have active CloudFront key pairs
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Current version of the distribution's information. For example: `E2QWRUHAPOMQZL`.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * CloudFront Route 53 zone ID that can be used to route an [Alias Resource Record Set](http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html) to. This attribute is simply an alias for the zone ID `Z2FDTNDATAQYW2`.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    public val httpVersion: Output<String>?
        get() = javaResource.httpVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of invalidation batches currently in progress.
     */
    public val inProgressValidationBatches: Output<Int>
        get() = javaResource.inProgressValidationBatches().applyValue({ args0 -> args0 })

    public val isIpv6Enabled: Output<Boolean>?
        get() = javaResource.isIpv6Enabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time the distribution was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    public val loggingConfig: Output<DistributionLoggingConfig>?
        get() = javaResource.loggingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionLoggingConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val orderedCacheBehaviors: Output<List<DistributionOrderedCacheBehavior>>?
        get() = javaResource.orderedCacheBehaviors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        distributionOrderedCacheBehaviorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val originGroups: Output<List<DistributionOriginGroup>>?
        get() = javaResource.originGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> distributionOriginGroupToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val origins: Output<List<DistributionOrigin>>
        get() = javaResource.origins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    distributionOriginToKotlin(args0)
                })
            })
        })

    public val priceClass: Output<String>?
        get() = javaResource.priceClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val restrictions: Output<DistributionRestrictions>
        get() = javaResource.restrictions().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionRestrictionsToKotlin(args0)
            })
        })

    public val retainOnDelete: Output<Boolean>?
        get() = javaResource.retainOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val staging: Output<Boolean>?
        get() = javaResource.staging().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * List of nested attributes for active trusted key groups, if the distribution is set up to serve private content with signed URLs.
     */
    public val trustedKeyGroups: Output<List<DistributionTrustedKeyGroup>>
        get() = javaResource.trustedKeyGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionTrustedKeyGroupToKotlin(args0) })
            })
        })

    /**
     * List of nested attributes for active trusted signers, if the distribution is set up to serve private content with signed URLs.
     */
    public val trustedSigners: Output<List<DistributionTrustedSigner>>
        get() = javaResource.trustedSigners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionTrustedSignerToKotlin(args0) })
            })
        })

    public val viewerCertificate: Output<DistributionViewerCertificate>
        get() = javaResource.viewerCertificate().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionViewerCertificateToKotlin(args0)
            })
        })

    public val waitForDeployment: Output<Boolean>?
        get() = javaResource.waitForDeployment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val webAclId: Output<String>?
        get() = javaResource.webAclId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DistributionMapper : ResourceMapper<Distribution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.Distribution::class == javaResource::class

    override fun map(javaResource: Resource): Distribution = Distribution(
        javaResource as
            com.pulumi.aws.cloudfront.Distribution,
    )
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Distribution].
 */
public suspend fun distribution(
    name: String,
    block: suspend DistributionResourceBuilder.() -> Unit,
): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun distribution(name: String): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    return builder.build()
}
