@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionProfileEncryptionEntities
import com.pulumi.aws.cloudfront.kotlin.outputs.FieldLevelEncryptionProfileEncryptionEntities.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FieldLevelEncryptionProfile].
 */
@PulumiTagMarker
public class FieldLevelEncryptionProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FieldLevelEncryptionProfileArgs = FieldLevelEncryptionProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FieldLevelEncryptionProfileArgsBuilder.() -> Unit) {
        val builder = FieldLevelEncryptionProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FieldLevelEncryptionProfile {
        val builtJavaResource =
            com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FieldLevelEncryptionProfile(builtJavaResource)
    }
}

/**
 * Provides a CloudFront Field-level Encryption Profile resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.cloudfront.PublicKey("example", {
 *     comment: "test public key",
 *     encodedKey: std.file({
 *         input: "public_key.pem",
 *     }).then(invoke => invoke.result),
 *     name: "test_key",
 * });
 * const test = new aws.cloudfront.FieldLevelEncryptionProfile("test", {
 *     comment: "test comment",
 *     name: "test profile",
 *     encryptionEntities: {
 *         items: [{
 *             publicKeyId: example.id,
 *             providerId: "test provider",
 *             fieldPatterns: {
 *                 items: ["DateOfBirth"],
 *             },
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.cloudfront.PublicKey("example",
 *     comment="test public key",
 *     encoded_key=std.file(input="public_key.pem").result,
 *     name="test_key")
 * test = aws.cloudfront.FieldLevelEncryptionProfile("test",
 *     comment="test comment",
 *     name="test profile",
 *     encryption_entities={
 *         "items": [{
 *             "public_key_id": example.id,
 *             "provider_id": "test provider",
 *             "field_patterns": {
 *                 "items": ["DateOfBirth"],
 *             },
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.PublicKey("example", new()
 *     {
 *         Comment = "test public key",
 *         EncodedKey = Std.File.Invoke(new()
 *         {
 *             Input = "public_key.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Name = "test_key",
 *     });
 *     var test = new Aws.CloudFront.FieldLevelEncryptionProfile("test", new()
 *     {
 *         Comment = "test comment",
 *         Name = "test profile",
 *         EncryptionEntities = new Aws.CloudFront.Inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs
 *         {
 *             Items = new[]
 *             {
 *                 new Aws.CloudFront.Inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs
 *                 {
 *                     PublicKeyId = example.Id,
 *                     ProviderId = "test provider",
 *                     FieldPatterns = new Aws.CloudFront.Inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs
 *                     {
 *                         Items = new[]
 *                         {
 *                             "DateOfBirth",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "public_key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := cloudfront.NewPublicKey(ctx, "example", &cloudfront.PublicKeyArgs{
 * 			Comment:    pulumi.String("test public key"),
 * 			EncodedKey: pulumi.String(invokeFile.Result),
 * 			Name:       pulumi.String("test_key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewFieldLevelEncryptionProfile(ctx, "test", &cloudfront.FieldLevelEncryptionProfileArgs{
 * 			Comment: pulumi.String("test comment"),
 * 			Name:    pulumi.String("test profile"),
 * 			EncryptionEntities: &cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesArgs{
 * 				Items: cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesItemArray{
 * 					&cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs{
 * 						PublicKeyId: example.ID(),
 * 						ProviderId:  pulumi.String("test provider"),
 * 						FieldPatterns: &cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs{
 * 							Items: pulumi.StringArray{
 * 								pulumi.String("DateOfBirth"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("test public key")
 *             .encodedKey(StdFunctions.file(FileArgs.builder()
 *                 .input("public_key.pem")
 *                 .build()).result())
 *             .name("test_key")
 *             .build());
 *         var test = new FieldLevelEncryptionProfile("test", FieldLevelEncryptionProfileArgs.builder()
 *             .comment("test comment")
 *             .name("test profile")
 *             .encryptionEntities(FieldLevelEncryptionProfileEncryptionEntitiesArgs.builder()
 *                 .items(FieldLevelEncryptionProfileEncryptionEntitiesItemArgs.builder()
 *                     .publicKeyId(example.id())
 *                     .providerId("test provider")
 *                     .fieldPatterns(FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs.builder()
 *                         .items("DateOfBirth")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:PublicKey
 *     properties:
 *       comment: test public key
 *       encodedKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: public_key.pem
 *           Return: result
 *       name: test_key
 *   test:
 *     type: aws:cloudfront:FieldLevelEncryptionProfile
 *     properties:
 *       comment: test comment
 *       name: test profile
 *       encryptionEntities:
 *         items:
 *           - publicKeyId: ${example.id}
 *             providerId: test provider
 *             fieldPatterns:
 *               items:
 *                 - DateOfBirth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudfront Field Level Encryption Profile using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile profile K3D5EWEUDCCXON
 * ```
 */
public class FieldLevelEncryptionProfile internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile,
) : KotlinCustomResource(javaResource, FieldLevelEncryptionProfileMapper) {
    /**
     * Internal value used by CloudFront to allow future updates to the Field Level Encryption Profile.
     */
    public val callerReference: Output<String>
        get() = javaResource.callerReference().applyValue({ args0 -> args0 })

    /**
     * An optional comment about the Field Level Encryption Profile.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    public val encryptionEntities: Output<FieldLevelEncryptionProfileEncryptionEntities>
        get() = javaResource.encryptionEntities().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The current version of the Field Level Encryption Profile. For example: `E2QWRUHAPOMQZL`.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the Field Level Encryption Profile.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object FieldLevelEncryptionProfileMapper : ResourceMapper<FieldLevelEncryptionProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile::class == javaResource::class

    override fun map(javaResource: Resource): FieldLevelEncryptionProfile =
        FieldLevelEncryptionProfile(
            javaResource as
                com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile,
        )
}

/**
 * @see [FieldLevelEncryptionProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FieldLevelEncryptionProfile].
 */
public suspend fun fieldLevelEncryptionProfile(
    name: String,
    block: suspend FieldLevelEncryptionProfileResourceBuilder.() -> Unit,
): FieldLevelEncryptionProfile {
    val builder = FieldLevelEncryptionProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FieldLevelEncryptionProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fieldLevelEncryptionProfile(name: String): FieldLevelEncryptionProfile {
    val builder = FieldLevelEncryptionProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
