@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront Field-level Encryption Profile resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.cloudfront.PublicKey("example", {
 *     comment: "test public key",
 *     encodedKey: std.file({
 *         input: "public_key.pem",
 *     }).then(invoke => invoke.result),
 *     name: "test_key",
 * });
 * const test = new aws.cloudfront.FieldLevelEncryptionProfile("test", {
 *     comment: "test comment",
 *     name: "test profile",
 *     encryptionEntities: {
 *         items: [{
 *             publicKeyId: example.id,
 *             providerId: "test provider",
 *             fieldPatterns: {
 *                 items: ["DateOfBirth"],
 *             },
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.cloudfront.PublicKey("example",
 *     comment="test public key",
 *     encoded_key=std.file(input="public_key.pem").result,
 *     name="test_key")
 * test = aws.cloudfront.FieldLevelEncryptionProfile("test",
 *     comment="test comment",
 *     name="test profile",
 *     encryption_entities={
 *         "items": [{
 *             "public_key_id": example.id,
 *             "provider_id": "test provider",
 *             "field_patterns": {
 *                 "items": ["DateOfBirth"],
 *             },
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.PublicKey("example", new()
 *     {
 *         Comment = "test public key",
 *         EncodedKey = Std.File.Invoke(new()
 *         {
 *             Input = "public_key.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Name = "test_key",
 *     });
 *     var test = new Aws.CloudFront.FieldLevelEncryptionProfile("test", new()
 *     {
 *         Comment = "test comment",
 *         Name = "test profile",
 *         EncryptionEntities = new Aws.CloudFront.Inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs
 *         {
 *             Items = new[]
 *             {
 *                 new Aws.CloudFront.Inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs
 *                 {
 *                     PublicKeyId = example.Id,
 *                     ProviderId = "test provider",
 *                     FieldPatterns = new Aws.CloudFront.Inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs
 *                     {
 *                         Items = new[]
 *                         {
 *                             "DateOfBirth",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "public_key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := cloudfront.NewPublicKey(ctx, "example", &cloudfront.PublicKeyArgs{
 * 			Comment:    pulumi.String("test public key"),
 * 			EncodedKey: pulumi.String(invokeFile.Result),
 * 			Name:       pulumi.String("test_key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewFieldLevelEncryptionProfile(ctx, "test", &cloudfront.FieldLevelEncryptionProfileArgs{
 * 			Comment: pulumi.String("test comment"),
 * 			Name:    pulumi.String("test profile"),
 * 			EncryptionEntities: &cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesArgs{
 * 				Items: cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesItemArray{
 * 					&cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs{
 * 						PublicKeyId: example.ID(),
 * 						ProviderId:  pulumi.String("test provider"),
 * 						FieldPatterns: &cloudfront.FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs{
 * 							Items: pulumi.StringArray{
 * 								pulumi.String("DateOfBirth"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("test public key")
 *             .encodedKey(StdFunctions.file(FileArgs.builder()
 *                 .input("public_key.pem")
 *                 .build()).result())
 *             .name("test_key")
 *             .build());
 *         var test = new FieldLevelEncryptionProfile("test", FieldLevelEncryptionProfileArgs.builder()
 *             .comment("test comment")
 *             .name("test profile")
 *             .encryptionEntities(FieldLevelEncryptionProfileEncryptionEntitiesArgs.builder()
 *                 .items(FieldLevelEncryptionProfileEncryptionEntitiesItemArgs.builder()
 *                     .publicKeyId(example.id())
 *                     .providerId("test provider")
 *                     .fieldPatterns(FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs.builder()
 *                         .items("DateOfBirth")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:PublicKey
 *     properties:
 *       comment: test public key
 *       encodedKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: public_key.pem
 *           Return: result
 *       name: test_key
 *   test:
 *     type: aws:cloudfront:FieldLevelEncryptionProfile
 *     properties:
 *       comment: test comment
 *       name: test profile
 *       encryptionEntities:
 *         items:
 *           - publicKeyId: ${example.id}
 *             providerId: test provider
 *             fieldPatterns:
 *               items:
 *                 - DateOfBirth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudfront Field Level Encryption Profile using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile profile K3D5EWEUDCCXON
 * ```
 * @property comment An optional comment about the Field Level Encryption Profile.
 * @property encryptionEntities The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
 * @property name The name of the Field Level Encryption Profile.
 */
public data class FieldLevelEncryptionProfileArgs(
    public val comment: Output<String>? = null,
    public val encryptionEntities: Output<FieldLevelEncryptionProfileEncryptionEntitiesArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs =
        com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .encryptionEntities(
                encryptionEntities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldLevelEncryptionProfileArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionProfileArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var encryptionEntities: Output<FieldLevelEncryptionProfileEncryptionEntitiesArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value An optional comment about the Field Level Encryption Profile.
     */
    @JvmName("brftqqymgwxyemrs")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    @JvmName("wmtgvsavagrioydk")
    public suspend fun encryptionEntities(`value`: Output<FieldLevelEncryptionProfileEncryptionEntitiesArgs>) {
        this.encryptionEntities = value
    }

    /**
     * @param value The name of the Field Level Encryption Profile.
     */
    @JvmName("shivgnskqwbfppbe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An optional comment about the Field Level Encryption Profile.
     */
    @JvmName("xxhmtmgaidvpitsg")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    @JvmName("cyhwqqnvktbbbpur")
    public suspend fun encryptionEntities(`value`: FieldLevelEncryptionProfileEncryptionEntitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionEntities = mapped
    }

    /**
     * @param argument The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     */
    @JvmName("tbirwwbfeoauahdd")
    public suspend fun encryptionEntities(argument: suspend FieldLevelEncryptionProfileEncryptionEntitiesArgsBuilder.() -> Unit) {
        val toBeMapped = FieldLevelEncryptionProfileEncryptionEntitiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionEntities = mapped
    }

    /**
     * @param value The name of the Field Level Encryption Profile.
     */
    @JvmName("whjkisijvgfwaukn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): FieldLevelEncryptionProfileArgs = FieldLevelEncryptionProfileArgs(
        comment = comment,
        encryptionEntities = encryptionEntities,
        name = name,
    )
}
