@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Function].
 */
@PulumiTagMarker
public class FunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FunctionArgs = FunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FunctionArgsBuilder.() -> Unit) {
        val builder = FunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Function {
        val builtJavaResource = com.pulumi.aws.cloudfront.Function(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Function(builtJavaResource)
    }
}

/**
 * Provides a CloudFront Function resource. With CloudFront Functions in Amazon CloudFront, you can write lightweight functions in JavaScript for high-scale, latency-sensitive CDN customizations.
 * See [CloudFront Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-functions.html)
 * > **NOTE:** You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import CloudFront Functions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/function:Function test my_test_function
 * ```
 */
public class Function internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.Function,
) : KotlinCustomResource(javaResource, FunctionMapper) {
    /**
     * Amazon Resource Name (ARN) identifying your CloudFront Function.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Source code of the function
     */
    public val code: Output<String>
        get() = javaResource.code().applyValue({ args0 -> args0 })

    /**
     * Comment.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ETag hash of the function. This is the value for the `DEVELOPMENT` stage of the function.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of `aws.cloudfront.KeyValueStore` ARNs to be associated to the function. AWS limits associations to on key value store per function.
     */
    public val keyValueStoreAssociations: Output<List<String>>?
        get() = javaResource.keyValueStoreAssociations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * ETag hash of any `LIVE` stage of the function.
     */
    public val liveStageEtag: Output<String>
        get() = javaResource.liveStageEtag().applyValue({ args0 -> args0 })

    /**
     * Unique name for your CloudFront Function.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
     */
    public val publish: Output<Boolean>?
        get() = javaResource.publish().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identifier of the function's runtime. Valid values are `cloudfront-js-1.0` and `cloudfront-js-2.0`.
     * The following arguments are optional:
     */
    public val runtime: Output<String>
        get() = javaResource.runtime().applyValue({ args0 -> args0 })

    /**
     * Status of the function. Can be `UNPUBLISHED`, `UNASSOCIATED` or `ASSOCIATED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object FunctionMapper : ResourceMapper<Function> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.Function::class == javaResource::class

    override fun map(javaResource: Resource): Function = Function(
        javaResource as
            com.pulumi.aws.cloudfront.Function,
    )
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Function].
 */
public suspend fun function(name: String, block: suspend FunctionResourceBuilder.() -> Unit): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 */
public fun function(name: String): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
