@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.FunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront Function resource. With CloudFront Functions in Amazon CloudFront, you can write lightweight functions in JavaScript for high-scale, latency-sensitive CDN customizations.
 * See [CloudFront Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-functions.html)
 * > **NOTE:** You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import CloudFront Functions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/function:Function test my_test_function
 * ```
 * @property code Source code of the function
 * @property comment Comment.
 * @property keyValueStoreAssociations List of `aws.cloudfront.KeyValueStore` ARNs to be associated to the function. AWS limits associations to on key value store per function.
 * @property name Unique name for your CloudFront Function.
 * @property publish Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
 * @property runtime Identifier of the function's runtime. Valid values are `cloudfront-js-1.0` and `cloudfront-js-2.0`.
 * The following arguments are optional:
 */
public data class FunctionArgs(
    public val code: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val keyValueStoreAssociations: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val publish: Output<Boolean>? = null,
    public val runtime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.FunctionArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.FunctionArgs =
        com.pulumi.aws.cloudfront.FunctionArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .keyValueStoreAssociations(
                keyValueStoreAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .publish(publish?.applyValue({ args0 -> args0 }))
            .runtime(runtime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var comment: Output<String>? = null

    private var keyValueStoreAssociations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var publish: Output<Boolean>? = null

    private var runtime: Output<String>? = null

    /**
     * @param value Source code of the function
     */
    @JvmName("teawlejaglbnqqht")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Comment.
     */
    @JvmName("qsmusgaweoyosroe")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value List of `aws.cloudfront.KeyValueStore` ARNs to be associated to the function. AWS limits associations to on key value store per function.
     */
    @JvmName("pbysnawmwgjfmxek")
    public suspend fun keyValueStoreAssociations(`value`: Output<List<String>>) {
        this.keyValueStoreAssociations = value
    }

    @JvmName("heddepxldlylabks")
    public suspend fun keyValueStoreAssociations(vararg values: Output<String>) {
        this.keyValueStoreAssociations = Output.all(values.asList())
    }

    /**
     * @param values List of `aws.cloudfront.KeyValueStore` ARNs to be associated to the function. AWS limits associations to on key value store per function.
     */
    @JvmName("tklndtymlxjxyvvr")
    public suspend fun keyValueStoreAssociations(values: List<Output<String>>) {
        this.keyValueStoreAssociations = Output.all(values)
    }

    /**
     * @param value Unique name for your CloudFront Function.
     */
    @JvmName("bpsyrychhicomxvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
     */
    @JvmName("buxrpbcjnxpdgjlb")
    public suspend fun publish(`value`: Output<Boolean>) {
        this.publish = value
    }

    /**
     * @param value Identifier of the function's runtime. Valid values are `cloudfront-js-1.0` and `cloudfront-js-2.0`.
     * The following arguments are optional:
     */
    @JvmName("kdkeeoprflkjnwdw")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value Source code of the function
     */
    @JvmName("vlcdsesswiapsrpf")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Comment.
     */
    @JvmName("kwqqkrwntopevgnq")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value List of `aws.cloudfront.KeyValueStore` ARNs to be associated to the function. AWS limits associations to on key value store per function.
     */
    @JvmName("edsrbqgxvwbswvar")
    public suspend fun keyValueStoreAssociations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyValueStoreAssociations = mapped
    }

    /**
     * @param values List of `aws.cloudfront.KeyValueStore` ARNs to be associated to the function. AWS limits associations to on key value store per function.
     */
    @JvmName("difldukbalanajxl")
    public suspend fun keyValueStoreAssociations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyValueStoreAssociations = mapped
    }

    /**
     * @param value Unique name for your CloudFront Function.
     */
    @JvmName("nurfroqbwrrcvclr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to publish creation/change as Live CloudFront Function Version. Defaults to `true`.
     */
    @JvmName("rbvkqrspumnmralc")
    public suspend fun publish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publish = mapped
    }

    /**
     * @param value Identifier of the function's runtime. Valid values are `cloudfront-js-1.0` and `cloudfront-js-2.0`.
     * The following arguments are optional:
     */
    @JvmName("xlyxmqewmtwwoebk")
    public suspend fun runtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        code = code,
        comment = comment,
        keyValueStoreAssociations = keyValueStoreAssociations,
        name = name,
        publish = publish,
        runtime = runtime,
    )
}
