@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [KeyGroup].
 */
@PulumiTagMarker
public class KeyGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyGroupArgs = KeyGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyGroupArgsBuilder.() -> Unit) {
        val builder = KeyGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyGroup {
        val builtJavaResource = com.pulumi.aws.cloudfront.KeyGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyGroup(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * The following example below creates a CloudFront key group.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.cloudfront.PublicKey("example", {
 *     comment: "example public key",
 *     encodedKey: std.file({
 *         input: "public_key.pem",
 *     }).then(invoke => invoke.result),
 *     name: "example-key",
 * });
 * const exampleKeyGroup = new aws.cloudfront.KeyGroup("example", {
 *     comment: "example key group",
 *     items: [example&#46;id],
 *     name: "example-key-group",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.cloudfront.PublicKey("example",
 *     comment="example public key",
 *     encoded_key=std.file(input="public_key.pem").result,
 *     name="example-key")
 * example_key_group = aws.cloudfront.KeyGroup("example",
 *     comment="example key group",
 *     items=[example&#46;id],
 *     name="example-key-group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.PublicKey("example", new()
 *     {
 *         Comment = "example public key",
 *         EncodedKey = Std.File.Invoke(new()
 *         {
 *             Input = "public_key.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Name = "example-key",
 *     });
 *     var exampleKeyGroup = new Aws.CloudFront.KeyGroup("example", new()
 *     {
 *         Comment = "example key group",
 *         Items = new[]
 *         {
 *             example.Id,
 *         },
 *         Name = "example-key-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "public_key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := cloudfront.NewPublicKey(ctx, "example", &cloudfront.PublicKeyArgs{
 * 			Comment:    pulumi.String("example public key"),
 * 			EncodedKey: pulumi.String(invokeFile.Result),
 * 			Name:       pulumi.String("example-key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewKeyGroup(ctx, "example", &cloudfront.KeyGroupArgs{
 * 			Comment: pulumi.String("example key group"),
 * 			Items: pulumi.StringArray{
 * 				example.ID(),
 * 			},
 * 			Name: pulumi.String("example-key-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.KeyGroup;
 * import com.pulumi.aws.cloudfront.KeyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("example public key")
 *             .encodedKey(StdFunctions.file(FileArgs.builder()
 *                 .input("public_key.pem")
 *                 .build()).result())
 *             .name("example-key")
 *             .build());
 *         var exampleKeyGroup = new KeyGroup("exampleKeyGroup", KeyGroupArgs.builder()
 *             .comment("example key group")
 *             .items(example.id())
 *             .name("example-key-group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:PublicKey
 *     properties:
 *       comment: example public key
 *       encodedKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: public_key.pem
 *           Return: result
 *       name: example-key
 *   exampleKeyGroup:
 *     type: aws:cloudfront:KeyGroup
 *     name: example
 *     properties:
 *       comment: example key group
 *       items:
 *         - ${example.id}
 *       name: example-key-group
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Key Group using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/keyGroup:KeyGroup example 4b4f2r1c-315d-5c2e-f093-216t50jed10f
 * ```
 */
public class KeyGroup internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.KeyGroup,
) : KotlinCustomResource(javaResource, KeyGroupMapper) {
    /**
     * A comment to describe the key group..
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The identifier for this version of the key group.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A list of the identifiers of the public keys in the key group.
     */
    public val items: Output<List<String>>
        get() = javaResource.items().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A name to identify the key group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object KeyGroupMapper : ResourceMapper<KeyGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.KeyGroup::class == javaResource::class

    override fun map(javaResource: Resource): KeyGroup = KeyGroup(
        javaResource as
            com.pulumi.aws.cloudfront.KeyGroup,
    )
}

/**
 * @see [KeyGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyGroup].
 */
public suspend fun keyGroup(name: String, block: suspend KeyGroupResourceBuilder.() -> Unit): KeyGroup {
    val builder = KeyGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyGroup(name: String): KeyGroup {
    val builder = KeyGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
