@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.KeyGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * The following example below creates a CloudFront key group.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.cloudfront.PublicKey("example", {
 *     comment: "example public key",
 *     encodedKey: std.file({
 *         input: "public_key.pem",
 *     }).then(invoke => invoke.result),
 *     name: "example-key",
 * });
 * const exampleKeyGroup = new aws.cloudfront.KeyGroup("example", {
 *     comment: "example key group",
 *     items: [example&#46;id],
 *     name: "example-key-group",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.cloudfront.PublicKey("example",
 *     comment="example public key",
 *     encoded_key=std.file(input="public_key.pem").result,
 *     name="example-key")
 * example_key_group = aws.cloudfront.KeyGroup("example",
 *     comment="example key group",
 *     items=[example&#46;id],
 *     name="example-key-group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.PublicKey("example", new()
 *     {
 *         Comment = "example public key",
 *         EncodedKey = Std.File.Invoke(new()
 *         {
 *             Input = "public_key.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Name = "example-key",
 *     });
 *     var exampleKeyGroup = new Aws.CloudFront.KeyGroup("example", new()
 *     {
 *         Comment = "example key group",
 *         Items = new[]
 *         {
 *             example.Id,
 *         },
 *         Name = "example-key-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "public_key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := cloudfront.NewPublicKey(ctx, "example", &cloudfront.PublicKeyArgs{
 * 			Comment:    pulumi.String("example public key"),
 * 			EncodedKey: pulumi.String(invokeFile.Result),
 * 			Name:       pulumi.String("example-key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewKeyGroup(ctx, "example", &cloudfront.KeyGroupArgs{
 * 			Comment: pulumi.String("example key group"),
 * 			Items: pulumi.StringArray{
 * 				example.ID(),
 * 			},
 * 			Name: pulumi.String("example-key-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.KeyGroup;
 * import com.pulumi.aws.cloudfront.KeyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("example public key")
 *             .encodedKey(StdFunctions.file(FileArgs.builder()
 *                 .input("public_key.pem")
 *                 .build()).result())
 *             .name("example-key")
 *             .build());
 *         var exampleKeyGroup = new KeyGroup("exampleKeyGroup", KeyGroupArgs.builder()
 *             .comment("example key group")
 *             .items(example.id())
 *             .name("example-key-group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:PublicKey
 *     properties:
 *       comment: example public key
 *       encodedKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: public_key.pem
 *           Return: result
 *       name: example-key
 *   exampleKeyGroup:
 *     type: aws:cloudfront:KeyGroup
 *     name: example
 *     properties:
 *       comment: example key group
 *       items:
 *         - ${example.id}
 *       name: example-key-group
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Key Group using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/keyGroup:KeyGroup example 4b4f2r1c-315d-5c2e-f093-216t50jed10f
 * ```
 * @property comment A comment to describe the key group..
 * @property items A list of the identifiers of the public keys in the key group.
 * @property name A name to identify the key group.
 */
public data class KeyGroupArgs(
    public val comment: Output<String>? = null,
    public val items: Output<List<String>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.KeyGroupArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.KeyGroupArgs =
        com.pulumi.aws.cloudfront.KeyGroupArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyGroupArgs].
 */
@PulumiTagMarker
public class KeyGroupArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var items: Output<List<String>>? = null

    private var name: Output<String>? = null

    /**
     * @param value A comment to describe the key group..
     */
    @JvmName("vlsdelgforxcwhue")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value A list of the identifiers of the public keys in the key group.
     */
    @JvmName("uhgdjvvkipsvnwrf")
    public suspend fun items(`value`: Output<List<String>>) {
        this.items = value
    }

    @JvmName("hnknaiyfldoiwipv")
    public suspend fun items(vararg values: Output<String>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values A list of the identifiers of the public keys in the key group.
     */
    @JvmName("uonynhuqetxcxuab")
    public suspend fun items(values: List<Output<String>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value A name to identify the key group.
     */
    @JvmName("iselvhrkhrqwfxyp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A comment to describe the key group..
     */
    @JvmName("uspwtoknfbturfkw")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value A list of the identifiers of the public keys in the key group.
     */
    @JvmName("faxvdetneoglkluy")
    public suspend fun items(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param values A list of the identifiers of the public keys in the key group.
     */
    @JvmName("bsijmbwlpyvpgjtk")
    public suspend fun items(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value A name to identify the key group.
     */
    @JvmName("kydjtmnkbyyucbgc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): KeyGroupArgs = KeyGroupArgs(
        comment = comment,
        items = items,
        name = name,
    )
}
