@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.KeyValueStoreTimeouts
import com.pulumi.aws.cloudfront.kotlin.outputs.KeyValueStoreTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyValueStore].
 */
@PulumiTagMarker
public class KeyValueStoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyValueStoreArgs = KeyValueStoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyValueStoreArgsBuilder.() -> Unit) {
        val builder = KeyValueStoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyValueStore {
        val builtJavaResource = com.pulumi.aws.cloudfront.KeyValueStore(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyValueStore(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudFront Key Value Store.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.KeyValueStore("example", {
 *     name: "ExampleKeyValueStore",
 *     comment: "This is an example key value store",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.KeyValueStore("example",
 *     name="ExampleKeyValueStore",
 *     comment="This is an example key value store")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.KeyValueStore("example", new()
 *     {
 *         Name = "ExampleKeyValueStore",
 *         Comment = "This is an example key value store",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewKeyValueStore(ctx, "example", &cloudfront.KeyValueStoreArgs{
 * 			Name:    pulumi.String("ExampleKeyValueStore"),
 * 			Comment: pulumi.String("This is an example key value store"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.KeyValueStore;
 * import com.pulumi.aws.cloudfront.KeyValueStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KeyValueStore("example", KeyValueStoreArgs.builder()
 *             .name("ExampleKeyValueStore")
 *             .comment("This is an example key value store")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:KeyValueStore
 *     properties:
 *       name: ExampleKeyValueStore
 *       comment: This is an example key value store
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Key Value Store using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/keyValueStore:KeyValueStore example example_store
 * ```
 */
public class KeyValueStore internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.KeyValueStore,
) : KotlinCustomResource(javaResource, KeyValueStoreMapper) {
    /**
     * Amazon Resource Name (ARN) identifying your CloudFront KeyValueStore.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Comment.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ETag hash of the KeyValueStore.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Unique name for your CloudFront KeyValueStore.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val timeouts: Output<KeyValueStoreTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object KeyValueStoreMapper : ResourceMapper<KeyValueStore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.KeyValueStore::class == javaResource::class

    override fun map(javaResource: Resource): KeyValueStore = KeyValueStore(
        javaResource as
            com.pulumi.aws.cloudfront.KeyValueStore,
    )
}

/**
 * @see [KeyValueStore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyValueStore].
 */
public suspend fun keyValueStore(
    name: String,
    block: suspend KeyValueStoreResourceBuilder.() -> Unit,
): KeyValueStore {
    val builder = KeyValueStoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyValueStore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyValueStore(name: String): KeyValueStore {
    val builder = KeyValueStoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
