@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.KeyValueStoreArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.KeyValueStoreTimeoutsArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.KeyValueStoreTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudFront Key Value Store.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.KeyValueStore("example", {
 *     name: "ExampleKeyValueStore",
 *     comment: "This is an example key value store",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.KeyValueStore("example",
 *     name="ExampleKeyValueStore",
 *     comment="This is an example key value store")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.KeyValueStore("example", new()
 *     {
 *         Name = "ExampleKeyValueStore",
 *         Comment = "This is an example key value store",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewKeyValueStore(ctx, "example", &cloudfront.KeyValueStoreArgs{
 * 			Name:    pulumi.String("ExampleKeyValueStore"),
 * 			Comment: pulumi.String("This is an example key value store"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.KeyValueStore;
 * import com.pulumi.aws.cloudfront.KeyValueStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KeyValueStore("example", KeyValueStoreArgs.builder()
 *             .name("ExampleKeyValueStore")
 *             .comment("This is an example key value store")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:KeyValueStore
 *     properties:
 *       name: ExampleKeyValueStore
 *       comment: This is an example key value store
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Key Value Store using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/keyValueStore:KeyValueStore example example_store
 * ```
 * @property comment Comment.
 * @property name Unique name for your CloudFront KeyValueStore.
 * The following arguments are optional:
 * @property timeouts
 */
public data class KeyValueStoreArgs(
    public val comment: Output<String>? = null,
    public val name: Output<String>? = null,
    public val timeouts: Output<KeyValueStoreTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.KeyValueStoreArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.KeyValueStoreArgs =
        com.pulumi.aws.cloudfront.KeyValueStoreArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyValueStoreArgs].
 */
@PulumiTagMarker
public class KeyValueStoreArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var name: Output<String>? = null

    private var timeouts: Output<KeyValueStoreTimeoutsArgs>? = null

    /**
     * @param value Comment.
     */
    @JvmName("xxtgmhisedkdaagq")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Unique name for your CloudFront KeyValueStore.
     * The following arguments are optional:
     */
    @JvmName("lyoiilfegssdsxrc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("siqresovarwdysdo")
    public suspend fun timeouts(`value`: Output<KeyValueStoreTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Comment.
     */
    @JvmName("rlplmchsscsbtpvh")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Unique name for your CloudFront KeyValueStore.
     * The following arguments are optional:
     */
    @JvmName("upmargofplgmofla")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("iokhuxafttkrsomo")
    public suspend fun timeouts(`value`: KeyValueStoreTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wpdxyobwancurbot")
    public suspend fun timeouts(argument: suspend KeyValueStoreTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = KeyValueStoreTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): KeyValueStoreArgs = KeyValueStoreArgs(
        comment = comment,
        name = name,
        timeouts = timeouts,
    )
}
