@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyvaluestoreKey].
 */
@PulumiTagMarker
public class KeyvaluestoreKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyvaluestoreKeyArgs = KeyvaluestoreKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyvaluestoreKeyArgsBuilder.() -> Unit) {
        val builder = KeyvaluestoreKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyvaluestoreKey {
        val builtJavaResource = com.pulumi.aws.cloudfront.KeyvaluestoreKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyvaluestoreKey(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CloudFront KeyValueStore Key.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.KeyValueStore("example", {
 *     name: "ExampleKeyValueStore",
 *     comment: "This is an example key value store",
 * });
 * const exampleKeyvaluestoreKey = new aws.cloudfront.KeyvaluestoreKey("example", {
 *     keyValueStoreArn: example.arn,
 *     key: "Test Key",
 *     value: "Test Value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.KeyValueStore("example",
 *     name="ExampleKeyValueStore",
 *     comment="This is an example key value store")
 * example_keyvaluestore_key = aws.cloudfront.KeyvaluestoreKey("example",
 *     key_value_store_arn=example.arn,
 *     key="Test Key",
 *     value="Test Value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.KeyValueStore("example", new()
 *     {
 *         Name = "ExampleKeyValueStore",
 *         Comment = "This is an example key value store",
 *     });
 *     var exampleKeyvaluestoreKey = new Aws.CloudFront.KeyvaluestoreKey("example", new()
 *     {
 *         KeyValueStoreArn = example.Arn,
 *         Key = "Test Key",
 *         Value = "Test Value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudfront.NewKeyValueStore(ctx, "example", &cloudfront.KeyValueStoreArgs{
 * 			Name:    pulumi.String("ExampleKeyValueStore"),
 * 			Comment: pulumi.String("This is an example key value store"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewKeyvaluestoreKey(ctx, "example", &cloudfront.KeyvaluestoreKeyArgs{
 * 			KeyValueStoreArn: example.Arn,
 * 			Key:              pulumi.String("Test Key"),
 * 			Value:            pulumi.String("Test Value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.KeyValueStore;
 * import com.pulumi.aws.cloudfront.KeyValueStoreArgs;
 * import com.pulumi.aws.cloudfront.KeyvaluestoreKey;
 * import com.pulumi.aws.cloudfront.KeyvaluestoreKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KeyValueStore("example", KeyValueStoreArgs.builder()
 *             .name("ExampleKeyValueStore")
 *             .comment("This is an example key value store")
 *             .build());
 *         var exampleKeyvaluestoreKey = new KeyvaluestoreKey("exampleKeyvaluestoreKey", KeyvaluestoreKeyArgs.builder()
 *             .keyValueStoreArn(example.arn())
 *             .key("Test Key")
 *             .value("Test Value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:KeyValueStore
 *     properties:
 *       name: ExampleKeyValueStore
 *       comment: This is an example key value store
 *   exampleKeyvaluestoreKey:
 *     type: aws:cloudfront:KeyvaluestoreKey
 *     name: example
 *     properties:
 *       keyValueStoreArn: ${example.arn}
 *       key: Test Key
 *       value: Test Value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront KeyValueStore Key using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/keyvaluestoreKey:KeyvaluestoreKey example arn:aws:cloudfront::111111111111:key-value-store/8562g61f-caba-2845-9d99-b97diwae5d3c,someKey
 * ```
 */
public class KeyvaluestoreKey internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.KeyvaluestoreKey,
) : KotlinCustomResource(javaResource, KeyvaluestoreKeyMapper) {
    /**
     * Key to put.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Key Value Store.
     */
    public val keyValueStoreArn: Output<String>
        get() = javaResource.keyValueStoreArn().applyValue({ args0 -> args0 })

    /**
     * Total size of the Key Value Store in bytes.
     */
    public val totalSizeInBytes: Output<Int>
        get() = javaResource.totalSizeInBytes().applyValue({ args0 -> args0 })

    /**
     * Value to put.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object KeyvaluestoreKeyMapper : ResourceMapper<KeyvaluestoreKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.KeyvaluestoreKey::class == javaResource::class

    override fun map(javaResource: Resource): KeyvaluestoreKey = KeyvaluestoreKey(
        javaResource as
            com.pulumi.aws.cloudfront.KeyvaluestoreKey,
    )
}

/**
 * @see [KeyvaluestoreKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyvaluestoreKey].
 */
public suspend fun keyvaluestoreKey(
    name: String,
    block: suspend KeyvaluestoreKeyResourceBuilder.() -> Unit,
): KeyvaluestoreKey {
    val builder = KeyvaluestoreKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyvaluestoreKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyvaluestoreKey(name: String): KeyvaluestoreKey {
    val builder = KeyvaluestoreKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
