@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.KeyvaluestoreKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CloudFront KeyValueStore Key.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.KeyValueStore("example", {
 *     name: "ExampleKeyValueStore",
 *     comment: "This is an example key value store",
 * });
 * const exampleKeyvaluestoreKey = new aws.cloudfront.KeyvaluestoreKey("example", {
 *     keyValueStoreArn: example.arn,
 *     key: "Test Key",
 *     value: "Test Value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.KeyValueStore("example",
 *     name="ExampleKeyValueStore",
 *     comment="This is an example key value store")
 * example_keyvaluestore_key = aws.cloudfront.KeyvaluestoreKey("example",
 *     key_value_store_arn=example.arn,
 *     key="Test Key",
 *     value="Test Value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.KeyValueStore("example", new()
 *     {
 *         Name = "ExampleKeyValueStore",
 *         Comment = "This is an example key value store",
 *     });
 *     var exampleKeyvaluestoreKey = new Aws.CloudFront.KeyvaluestoreKey("example", new()
 *     {
 *         KeyValueStoreArn = example.Arn,
 *         Key = "Test Key",
 *         Value = "Test Value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudfront.NewKeyValueStore(ctx, "example", &cloudfront.KeyValueStoreArgs{
 * 			Name:    pulumi.String("ExampleKeyValueStore"),
 * 			Comment: pulumi.String("This is an example key value store"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewKeyvaluestoreKey(ctx, "example", &cloudfront.KeyvaluestoreKeyArgs{
 * 			KeyValueStoreArn: example.Arn,
 * 			Key:              pulumi.String("Test Key"),
 * 			Value:            pulumi.String("Test Value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.KeyValueStore;
 * import com.pulumi.aws.cloudfront.KeyValueStoreArgs;
 * import com.pulumi.aws.cloudfront.KeyvaluestoreKey;
 * import com.pulumi.aws.cloudfront.KeyvaluestoreKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KeyValueStore("example", KeyValueStoreArgs.builder()
 *             .name("ExampleKeyValueStore")
 *             .comment("This is an example key value store")
 *             .build());
 *         var exampleKeyvaluestoreKey = new KeyvaluestoreKey("exampleKeyvaluestoreKey", KeyvaluestoreKeyArgs.builder()
 *             .keyValueStoreArn(example.arn())
 *             .key("Test Key")
 *             .value("Test Value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:KeyValueStore
 *     properties:
 *       name: ExampleKeyValueStore
 *       comment: This is an example key value store
 *   exampleKeyvaluestoreKey:
 *     type: aws:cloudfront:KeyvaluestoreKey
 *     name: example
 *     properties:
 *       keyValueStoreArn: ${example.arn}
 *       key: Test Key
 *       value: Test Value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront KeyValueStore Key using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/keyvaluestoreKey:KeyvaluestoreKey example arn:aws:cloudfront::111111111111:key-value-store/8562g61f-caba-2845-9d99-b97diwae5d3c,someKey
 * ```
 * @property key Key to put.
 * @property keyValueStoreArn Amazon Resource Name (ARN) of the Key Value Store.
 * @property value Value to put.
 */
public data class KeyvaluestoreKeyArgs(
    public val key: Output<String>? = null,
    public val keyValueStoreArn: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.KeyvaluestoreKeyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.KeyvaluestoreKeyArgs =
        com.pulumi.aws.cloudfront.KeyvaluestoreKeyArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .keyValueStoreArn(keyValueStoreArn?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyvaluestoreKeyArgs].
 */
@PulumiTagMarker
public class KeyvaluestoreKeyArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var keyValueStoreArn: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key to put.
     */
    @JvmName("vtdxkfqdxvwqoras")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Value Store.
     */
    @JvmName("obntxveflunwbfho")
    public suspend fun keyValueStoreArn(`value`: Output<String>) {
        this.keyValueStoreArn = value
    }

    /**
     * @param value Value to put.
     */
    @JvmName("deavbixvgsfumisk")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key to put.
     */
    @JvmName("tljgsmwtmcfncqkc")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Value Store.
     */
    @JvmName("whbyqeqbmpcbbngs")
    public suspend fun keyValueStoreArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyValueStoreArn = mapped
    }

    /**
     * @param value Value to put.
     */
    @JvmName("ueiwivgqaykvlihv")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): KeyvaluestoreKeyArgs = KeyvaluestoreKeyArgs(
        key = key,
        keyValueStoreArn = keyValueStoreArn,
        `value` = `value`,
    )
}
