@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.MonitoringSubscriptionMonitoringSubscriptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront real-time log configuration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.MonitoringSubscription("example", {
 *     distributionId: exampleAwsCloudfrontDistribution.id,
 *     monitoringSubscription: {
 *         realtimeMetricsSubscriptionConfig: {
 *             realtimeMetricsSubscriptionStatus: "Enabled",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.MonitoringSubscription("example",
 *     distribution_id=example_aws_cloudfront_distribution["id"],
 *     monitoring_subscription={
 *         "realtime_metrics_subscription_config": {
 *             "realtime_metrics_subscription_status": "Enabled",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.MonitoringSubscription("example", new()
 *     {
 *         DistributionId = exampleAwsCloudfrontDistribution.Id,
 *         MonitoringSubscriptionDetails = new Aws.CloudFront.Inputs.MonitoringSubscriptionMonitoringSubscriptionArgs
 *         {
 *             RealtimeMetricsSubscriptionConfig = new Aws.CloudFront.Inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs
 *             {
 *                 RealtimeMetricsSubscriptionStatus = "Enabled",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewMonitoringSubscription(ctx, "example", &cloudfront.MonitoringSubscriptionArgs{
 * 			DistributionId: pulumi.Any(exampleAwsCloudfrontDistribution.Id),
 * 			MonitoringSubscription: &cloudfront.MonitoringSubscriptionMonitoringSubscriptionArgs{
 * 				RealtimeMetricsSubscriptionConfig: &cloudfront.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs{
 * 					RealtimeMetricsSubscriptionStatus: pulumi.String("Enabled"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.MonitoringSubscription;
 * import com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs;
 * import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionArgs;
 * import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MonitoringSubscription("example", MonitoringSubscriptionArgs.builder()
 *             .distributionId(exampleAwsCloudfrontDistribution.id())
 *             .monitoringSubscription(MonitoringSubscriptionMonitoringSubscriptionArgs.builder()
 *                 .realtimeMetricsSubscriptionConfig(MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs.builder()
 *                     .realtimeMetricsSubscriptionStatus("Enabled")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:MonitoringSubscription
 *     properties:
 *       distributionId: ${exampleAwsCloudfrontDistribution.id}
 *       monitoringSubscription:
 *         realtimeMetricsSubscriptionConfig:
 *           realtimeMetricsSubscriptionStatus: Enabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront monitoring subscription using the id. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/monitoringSubscription:MonitoringSubscription example E3QYSUHO4VYRGB
 * ```
 * @property distributionId The ID of the distribution that you are enabling metrics for.
 * @property monitoringSubscription A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
 */
public data class MonitoringSubscriptionArgs(
    public val distributionId: Output<String>? = null,
    public val monitoringSubscription: Output<MonitoringSubscriptionMonitoringSubscriptionArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs =
        com.pulumi.aws.cloudfront.MonitoringSubscriptionArgs.builder()
            .distributionId(distributionId?.applyValue({ args0 -> args0 }))
            .monitoringSubscription(
                monitoringSubscription?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MonitoringSubscriptionArgs].
 */
@PulumiTagMarker
public class MonitoringSubscriptionArgsBuilder internal constructor() {
    private var distributionId: Output<String>? = null

    private var monitoringSubscription: Output<MonitoringSubscriptionMonitoringSubscriptionArgs>? =
        null

    /**
     * @param value The ID of the distribution that you are enabling metrics for.
     */
    @JvmName("mhkablsfjjqgktuu")
    public suspend fun distributionId(`value`: Output<String>) {
        this.distributionId = value
    }

    /**
     * @param value A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    @JvmName("shdoitxwiuibclpn")
    public suspend fun monitoringSubscription(`value`: Output<MonitoringSubscriptionMonitoringSubscriptionArgs>) {
        this.monitoringSubscription = value
    }

    /**
     * @param value The ID of the distribution that you are enabling metrics for.
     */
    @JvmName("evebqmdutpllauhq")
    public suspend fun distributionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionId = mapped
    }

    /**
     * @param value A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    @JvmName("nsbtaqpofxokkjnr")
    public suspend fun monitoringSubscription(`value`: MonitoringSubscriptionMonitoringSubscriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringSubscription = mapped
    }

    /**
     * @param argument A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     */
    @JvmName("gvntgwwwkgqhihch")
    public suspend fun monitoringSubscription(argument: suspend MonitoringSubscriptionMonitoringSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringSubscriptionMonitoringSubscriptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.monitoringSubscription = mapped
    }

    internal fun build(): MonitoringSubscriptionArgs = MonitoringSubscriptionArgs(
        distributionId = distributionId,
        monitoringSubscription = monitoringSubscription,
    )
}
