@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.OriginAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AWS CloudFront Origin Access Control, which is used by CloudFront Distributions with an Amazon S3 bucket as the origin.
 * Read more about Origin Access Control in the [CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.OriginAccessControl("example", {
 *     name: "example",
 *     description: "Example Policy",
 *     originAccessControlOriginType: "s3",
 *     signingBehavior: "always",
 *     signingProtocol: "sigv4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.OriginAccessControl("example",
 *     name="example",
 *     description="Example Policy",
 *     origin_access_control_origin_type="s3",
 *     signing_behavior="always",
 *     signing_protocol="sigv4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.OriginAccessControl("example", new()
 *     {
 *         Name = "example",
 *         Description = "Example Policy",
 *         OriginAccessControlOriginType = "s3",
 *         SigningBehavior = "always",
 *         SigningProtocol = "sigv4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewOriginAccessControl(ctx, "example", &cloudfront.OriginAccessControlArgs{
 * 			Name:                          pulumi.String("example"),
 * 			Description:                   pulumi.String("Example Policy"),
 * 			OriginAccessControlOriginType: pulumi.String("s3"),
 * 			SigningBehavior:               pulumi.String("always"),
 * 			SigningProtocol:               pulumi.String("sigv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.OriginAccessControl;
 * import com.pulumi.aws.cloudfront.OriginAccessControlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OriginAccessControl("example", OriginAccessControlArgs.builder()
 *             .name("example")
 *             .description("Example Policy")
 *             .originAccessControlOriginType("s3")
 *             .signingBehavior("always")
 *             .signingProtocol("sigv4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:OriginAccessControl
 *     properties:
 *       name: example
 *       description: Example Policy
 *       originAccessControlOriginType: s3
 *       signingBehavior: always
 *       signingProtocol: sigv4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Origin Access Control using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/originAccessControl:OriginAccessControl example E327GJI25M56DG
 * ```
 * @property description The description of the Origin Access Control. Defaults to "Managed by Pulumi" if omitted.
 * @property name A name that identifies the Origin Access Control.
 * @property originAccessControlOriginType The type of origin that this Origin Access Control is for. Valid values are `lambda`, `mediapackagev2`, `mediastore`, and `s3`.
 * @property signingBehavior Specifies which requests CloudFront signs. Specify `always` for the most common use case. Allowed values: `always`, `never`, and `no-override`.
 * @property signingProtocol Determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
 */
public data class OriginAccessControlArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val originAccessControlOriginType: Output<String>? = null,
    public val signingBehavior: Output<String>? = null,
    public val signingProtocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.OriginAccessControlArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.OriginAccessControlArgs =
        com.pulumi.aws.cloudfront.OriginAccessControlArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .originAccessControlOriginType(originAccessControlOriginType?.applyValue({ args0 -> args0 }))
            .signingBehavior(signingBehavior?.applyValue({ args0 -> args0 }))
            .signingProtocol(signingProtocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OriginAccessControlArgs].
 */
@PulumiTagMarker
public class OriginAccessControlArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var originAccessControlOriginType: Output<String>? = null

    private var signingBehavior: Output<String>? = null

    private var signingProtocol: Output<String>? = null

    /**
     * @param value The description of the Origin Access Control. Defaults to "Managed by Pulumi" if omitted.
     */
    @JvmName("snetillxesbnpmwu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A name that identifies the Origin Access Control.
     */
    @JvmName("tqcbtyyblxwnipgn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of origin that this Origin Access Control is for. Valid values are `lambda`, `mediapackagev2`, `mediastore`, and `s3`.
     */
    @JvmName("jfogmsrqhohuurfa")
    public suspend fun originAccessControlOriginType(`value`: Output<String>) {
        this.originAccessControlOriginType = value
    }

    /**
     * @param value Specifies which requests CloudFront signs. Specify `always` for the most common use case. Allowed values: `always`, `never`, and `no-override`.
     */
    @JvmName("cdblyoycaijxmoli")
    public suspend fun signingBehavior(`value`: Output<String>) {
        this.signingBehavior = value
    }

    /**
     * @param value Determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
     */
    @JvmName("bgxxpaplyuhnhreg")
    public suspend fun signingProtocol(`value`: Output<String>) {
        this.signingProtocol = value
    }

    /**
     * @param value The description of the Origin Access Control. Defaults to "Managed by Pulumi" if omitted.
     */
    @JvmName("kbgjufvpwrgraqde")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A name that identifies the Origin Access Control.
     */
    @JvmName("xmgduftqctlroqnm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of origin that this Origin Access Control is for. Valid values are `lambda`, `mediapackagev2`, `mediastore`, and `s3`.
     */
    @JvmName("pfcesopqmowqeckl")
    public suspend fun originAccessControlOriginType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originAccessControlOriginType = mapped
    }

    /**
     * @param value Specifies which requests CloudFront signs. Specify `always` for the most common use case. Allowed values: `always`, `never`, and `no-override`.
     */
    @JvmName("vtmvioqycqlttnkr")
    public suspend fun signingBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingBehavior = mapped
    }

    /**
     * @param value Determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
     */
    @JvmName("jytogmnensedtpxx")
    public suspend fun signingProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingProtocol = mapped
    }

    internal fun build(): OriginAccessControlArgs = OriginAccessControlArgs(
        description = description,
        name = name,
        originAccessControlOriginType = originAccessControlOriginType,
        signingBehavior = signingBehavior,
        signingProtocol = signingProtocol,
    )
}
