@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.kotlin.outputs.OriginRequestPolicyCookiesConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.OriginRequestPolicyHeadersConfig
import com.pulumi.aws.cloudfront.kotlin.outputs.OriginRequestPolicyQueryStringsConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.cloudfront.kotlin.outputs.OriginRequestPolicyCookiesConfig.Companion.toKotlin as originRequestPolicyCookiesConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.OriginRequestPolicyHeadersConfig.Companion.toKotlin as originRequestPolicyHeadersConfigToKotlin
import com.pulumi.aws.cloudfront.kotlin.outputs.OriginRequestPolicyQueryStringsConfig.Companion.toKotlin as originRequestPolicyQueryStringsConfigToKotlin

/**
 * Builder for [OriginRequestPolicy].
 */
@PulumiTagMarker
public class OriginRequestPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OriginRequestPolicyArgs = OriginRequestPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OriginRequestPolicyArgsBuilder.() -> Unit) {
        val builder = OriginRequestPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OriginRequestPolicy {
        val builtJavaResource = com.pulumi.aws.cloudfront.OriginRequestPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OriginRequestPolicy(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * The following example below creates a CloudFront origin request policy.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.OriginRequestPolicy("example", {
 *     name: "example-policy",
 *     comment: "example comment",
 *     cookiesConfig: {
 *         cookieBehavior: "whitelist",
 *         cookies: {
 *             items: ["example"],
 *         },
 *     },
 *     headersConfig: {
 *         headerBehavior: "whitelist",
 *         headers: {
 *             items: ["example"],
 *         },
 *     },
 *     queryStringsConfig: {
 *         queryStringBehavior: "whitelist",
 *         queryStrings: {
 *             items: ["example"],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.OriginRequestPolicy("example",
 *     name="example-policy",
 *     comment="example comment",
 *     cookies_config={
 *         "cookie_behavior": "whitelist",
 *         "cookies": {
 *             "items": ["example"],
 *         },
 *     },
 *     headers_config={
 *         "header_behavior": "whitelist",
 *         "headers": {
 *             "items": ["example"],
 *         },
 *     },
 *     query_strings_config={
 *         "query_string_behavior": "whitelist",
 *         "query_strings": {
 *             "items": ["example"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.OriginRequestPolicy("example", new()
 *     {
 *         Name = "example-policy",
 *         Comment = "example comment",
 *         CookiesConfig = new Aws.CloudFront.Inputs.OriginRequestPolicyCookiesConfigArgs
 *         {
 *             CookieBehavior = "whitelist",
 *             Cookies = new Aws.CloudFront.Inputs.OriginRequestPolicyCookiesConfigCookiesArgs
 *             {
 *                 Items = new[]
 *                 {
 *                     "example",
 *                 },
 *             },
 *         },
 *         HeadersConfig = new Aws.CloudFront.Inputs.OriginRequestPolicyHeadersConfigArgs
 *         {
 *             HeaderBehavior = "whitelist",
 *             Headers = new Aws.CloudFront.Inputs.OriginRequestPolicyHeadersConfigHeadersArgs
 *             {
 *                 Items = new[]
 *                 {
 *                     "example",
 *                 },
 *             },
 *         },
 *         QueryStringsConfig = new Aws.CloudFront.Inputs.OriginRequestPolicyQueryStringsConfigArgs
 *         {
 *             QueryStringBehavior = "whitelist",
 *             QueryStrings = new Aws.CloudFront.Inputs.OriginRequestPolicyQueryStringsConfigQueryStringsArgs
 *             {
 *                 Items = new[]
 *                 {
 *                     "example",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewOriginRequestPolicy(ctx, "example", &cloudfront.OriginRequestPolicyArgs{
 * 			Name:    pulumi.String("example-policy"),
 * 			Comment: pulumi.String("example comment"),
 * 			CookiesConfig: &cloudfront.OriginRequestPolicyCookiesConfigArgs{
 * 				CookieBehavior: pulumi.String("whitelist"),
 * 				Cookies: &cloudfront.OriginRequestPolicyCookiesConfigCookiesArgs{
 * 					Items: pulumi.StringArray{
 * 						pulumi.String("example"),
 * 					},
 * 				},
 * 			},
 * 			HeadersConfig: &cloudfront.OriginRequestPolicyHeadersConfigArgs{
 * 				HeaderBehavior: pulumi.String("whitelist"),
 * 				Headers: &cloudfront.OriginRequestPolicyHeadersConfigHeadersArgs{
 * 					Items: pulumi.StringArray{
 * 						pulumi.String("example"),
 * 					},
 * 				},
 * 			},
 * 			QueryStringsConfig: &cloudfront.OriginRequestPolicyQueryStringsConfigArgs{
 * 				QueryStringBehavior: pulumi.String("whitelist"),
 * 				QueryStrings: &cloudfront.OriginRequestPolicyQueryStringsConfigQueryStringsArgs{
 * 					Items: pulumi.StringArray{
 * 						pulumi.String("example"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.OriginRequestPolicy;
 * import com.pulumi.aws.cloudfront.OriginRequestPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigCookiesArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyHeadersConfigHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OriginRequestPolicy("example", OriginRequestPolicyArgs.builder()
 *             .name("example-policy")
 *             .comment("example comment")
 *             .cookiesConfig(OriginRequestPolicyCookiesConfigArgs.builder()
 *                 .cookieBehavior("whitelist")
 *                 .cookies(OriginRequestPolicyCookiesConfigCookiesArgs.builder()
 *                     .items("example")
 *                     .build())
 *                 .build())
 *             .headersConfig(OriginRequestPolicyHeadersConfigArgs.builder()
 *                 .headerBehavior("whitelist")
 *                 .headers(OriginRequestPolicyHeadersConfigHeadersArgs.builder()
 *                     .items("example")
 *                     .build())
 *                 .build())
 *             .queryStringsConfig(OriginRequestPolicyQueryStringsConfigArgs.builder()
 *                 .queryStringBehavior("whitelist")
 *                 .queryStrings(OriginRequestPolicyQueryStringsConfigQueryStringsArgs.builder()
 *                     .items("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:OriginRequestPolicy
 *     properties:
 *       name: example-policy
 *       comment: example comment
 *       cookiesConfig:
 *         cookieBehavior: whitelist
 *         cookies:
 *           items:
 *             - example
 *       headersConfig:
 *         headerBehavior: whitelist
 *         headers:
 *           items:
 *             - example
 *       queryStringsConfig:
 *         queryStringBehavior: whitelist
 *         queryStrings:
 *           items:
 *             - example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudfront Origin Request Policies using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/originRequestPolicy:OriginRequestPolicy policy ccca32ef-dce3-4df3-80df-1bd3000bc4d3
 * ```
 */
public class OriginRequestPolicy internal constructor(
    override val javaResource: com.pulumi.aws.cloudfront.OriginRequestPolicy,
) : KotlinCustomResource(javaResource, OriginRequestPolicyMapper) {
    /**
     * Comment to describe the origin request policy.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
     */
    public val cookiesConfig: Output<OriginRequestPolicyCookiesConfig>
        get() = javaResource.cookiesConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                originRequestPolicyCookiesConfigToKotlin(args0)
            })
        })

    /**
     * The current version of the origin request policy.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Object that determines whether any HTTP headers (and if so, which headers) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
     */
    public val headersConfig: Output<OriginRequestPolicyHeadersConfig>
        get() = javaResource.headersConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                originRequestPolicyHeadersConfigToKotlin(args0)
            })
        })

    /**
     * Unique name to identify the origin request policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the origin request key and automatically included in requests that CloudFront sends to the origin. See Query String Config for more information.
     */
    public val queryStringsConfig: Output<OriginRequestPolicyQueryStringsConfig>
        get() = javaResource.queryStringsConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                originRequestPolicyQueryStringsConfigToKotlin(args0)
            })
        })
}

public object OriginRequestPolicyMapper : ResourceMapper<OriginRequestPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudfront.OriginRequestPolicy::class == javaResource::class

    override fun map(javaResource: Resource): OriginRequestPolicy = OriginRequestPolicy(
        javaResource
            as com.pulumi.aws.cloudfront.OriginRequestPolicy,
    )
}

/**
 * @see [OriginRequestPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OriginRequestPolicy].
 */
public suspend fun originRequestPolicy(
    name: String,
    block: suspend OriginRequestPolicyResourceBuilder.() -> Unit,
): OriginRequestPolicy {
    val builder = OriginRequestPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OriginRequestPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun originRequestPolicy(name: String): OriginRequestPolicy {
    val builder = OriginRequestPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
