@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.PublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * The following example below creates a CloudFront public key.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.cloudfront.PublicKey("example", {
 *     comment: "test public key",
 *     encodedKey: std.file({
 *         input: "public_key.pem",
 *     }).then(invoke => invoke.result),
 *     name: "test_key",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.cloudfront.PublicKey("example",
 *     comment="test public key",
 *     encoded_key=std.file(input="public_key.pem").result,
 *     name="test_key")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.PublicKey("example", new()
 *     {
 *         Comment = "test public key",
 *         EncodedKey = Std.File.Invoke(new()
 *         {
 *             Input = "public_key.pem",
 *         }).Apply(invoke => invoke.Result),
 *         Name = "test_key",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "public_key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cloudfront.NewPublicKey(ctx, "example", &cloudfront.PublicKeyArgs{
 * 			Comment:    pulumi.String("test public key"),
 * 			EncodedKey: pulumi.String(invokeFile.Result),
 * 			Name:       pulumi.String("test_key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey("example", PublicKeyArgs.builder()
 *             .comment("test public key")
 *             .encodedKey(StdFunctions.file(FileArgs.builder()
 *                 .input("public_key.pem")
 *                 .build()).result())
 *             .name("test_key")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:PublicKey
 *     properties:
 *       comment: test public key
 *       encodedKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: public_key.pem
 *           Return: result
 *       name: test_key
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront Public Key using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/publicKey:PublicKey example K3D5EWEUDCCXON
 * ```
 * @property comment An optional comment about the public key.
 * @property encodedKey The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
 * @property name The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
 * @property namePrefix The name for the public key. Conflicts with `name`.
 * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
 */
public data class PublicKeyArgs(
    public val comment: Output<String>? = null,
    public val encodedKey: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.PublicKeyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.PublicKeyArgs =
        com.pulumi.aws.cloudfront.PublicKeyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .encodedKey(encodedKey?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublicKeyArgs].
 */
@PulumiTagMarker
public class PublicKeyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var encodedKey: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    /**
     * @param value An optional comment about the public key.
     */
    @JvmName("dahjqeaodnyxouwk")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     */
    @JvmName("wptdauflhrsaivjf")
    public suspend fun encodedKey(`value`: Output<String>) {
        this.encodedKey = value
    }

    /**
     * @param value The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
     */
    @JvmName("pokpjqsvuftbojpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name for the public key. Conflicts with `name`.
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     */
    @JvmName("xtoagsgguskvsumc")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value An optional comment about the public key.
     */
    @JvmName("wdpyywuacfiijady")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     */
    @JvmName("pigtkvgwyuirhpus")
    public suspend fun encodedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedKey = mapped
    }

    /**
     * @param value The name for the public key. By default generated by this provider. Note: Do not set if using the key's id in another resource (e.g. KeyGroup) since it will result in a dependency error from AWS. Instead, it is recommended to use Pulumi autonaming by leaving this property unset (default behavior) or set the `namePrefix` property to allow the provider to autoname the resource.
     */
    @JvmName("qkuydhhqpugieiwm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name for the public key. Conflicts with `name`.
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     */
    @JvmName("eggavmsargmlisup")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    internal fun build(): PublicKeyArgs = PublicKeyArgs(
        comment = comment,
        encodedKey = encodedKey,
        name = name,
        namePrefix = namePrefix,
    )
}
