@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.RealtimeLogConfigArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.RealtimeLogConfigEndpointArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.RealtimeLogConfigEndpointArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront real-time log configuration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["cloudfront&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "cloudfront-realtime-log-config-example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: [
 *             "kinesis:DescribeStreamSummary",
 *             "kinesis:DescribeStream",
 *             "kinesis:PutRecord",
 *             "kinesis:PutRecords",
 *         ],
 *         resources: [exampleAwsKinesisStream&#46;arn],
 *     }],
 * });
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     name: "cloudfront-realtime-log-config-example",
 *     role: exampleRole.id,
 *     policy: example.then(example => example.json),
 * });
 * const exampleRealtimeLogConfig = new aws.cloudfront.RealtimeLogConfig("example", {
 *     name: "example",
 *     samplingRate: 75,
 *     fields: [
 *         "timestamp",
 *         "c-ip",
 *     ],
 *     endpoint: {
 *         streamType: "Kinesis",
 *         kinesisStreamConfig: {
 *             roleArn: exampleRole.arn,
 *             streamArn: exampleAwsKinesisStream.arn,
 *         },
 *     },
 * }, {
 *     dependsOn: [exampleRolePolicy],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["cloudfront&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="cloudfront-realtime-log-config-example",
 *     assume_role_policy=assume_role.json)
 * example = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": [
 *         "kinesis:DescribeStreamSummary",
 *         "kinesis:DescribeStream",
 *         "kinesis:PutRecord",
 *         "kinesis:PutRecords",
 *     ],
 *     "resources": [example_aws_kinesis_stream["arn"]],
 * }])
 * example_role_policy = aws.iam.RolePolicy("example",
 *     name="cloudfront-realtime-log-config-example",
 *     role=example_role.id,
 *     policy=example.json)
 * example_realtime_log_config = aws.cloudfront.RealtimeLogConfig("example",
 *     name="example",
 *     sampling_rate=75,
 *     fields=[
 *         "timestamp",
 *         "c-ip",
 *     ],
 *     endpoint={
 *         "stream_type": "Kinesis",
 *         "kinesis_stream_config": {
 *             "role_arn": example_role.arn,
 *             "stream_arn": example_aws_kinesis_stream["arn"],
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_role_policy]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "cloudfront.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "cloudfront-realtime-log-config-example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "kinesis:DescribeStreamSummary",
 *                     "kinesis:DescribeStream",
 *                     "kinesis:PutRecord",
 *                     "kinesis:PutRecords",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleAwsKinesisStream.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Name = "cloudfront-realtime-log-config-example",
 *         Role = exampleRole.Id,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleRealtimeLogConfig = new Aws.CloudFront.RealtimeLogConfig("example", new()
 *     {
 *         Name = "example",
 *         SamplingRate = 75,
 *         Fields = new[]
 *         {
 *             "timestamp",
 *             "c-ip",
 *         },
 *         Endpoint = new Aws.CloudFront.Inputs.RealtimeLogConfigEndpointArgs
 *         {
 *             StreamType = "Kinesis",
 *             KinesisStreamConfig = new Aws.CloudFront.Inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs
 *             {
 *                 RoleArn = exampleRole.Arn,
 *                 StreamArn = exampleAwsKinesisStream.Arn,
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleRolePolicy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: pulumi.StringRef("Allow"),
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "cloudfront.amazonaws.com",
 * },
 * },
 * },
 * Actions: []string{
 * "sts:AssumeRole",
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * Name: pulumi.String("cloudfront-realtime-log-config-example"),
 * AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * })
 * if err != nil {
 * return err
 * }
 * example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: pulumi.StringRef("Allow"),
 * Actions: []string{
 * "kinesis:DescribeStreamSummary",
 * "kinesis:DescribeStream",
 * "kinesis:PutRecord",
 * "kinesis:PutRecords",
 * },
 * Resources: interface{}{
 * exampleAwsKinesisStream.Arn,
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleRolePolicy, err := iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * Name: pulumi.String("cloudfront-realtime-log-config-example"),
 * Role: exampleRole.ID(),
 * Policy: pulumi.String(example.Json),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = cloudfront.NewRealtimeLogConfig(ctx, "example", &cloudfront.RealtimeLogConfigArgs{
 * Name: pulumi.String("example"),
 * SamplingRate: pulumi.Int(75),
 * Fields: pulumi.StringArray{
 * pulumi.String("timestamp"),
 * pulumi.String("c-ip"),
 * },
 * Endpoint: &cloudfront.RealtimeLogConfigEndpointArgs{
 * StreamType: pulumi.String("Kinesis"),
 * KinesisStreamConfig: &cloudfront.RealtimeLogConfigEndpointKinesisStreamConfigArgs{
 * RoleArn: exampleRole.Arn,
 * StreamArn: pulumi.Any(exampleAwsKinesisStream.Arn),
 * },
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * exampleRolePolicy,
 * }))
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.cloudfront.RealtimeLogConfig;
 * import com.pulumi.aws.cloudfront.RealtimeLogConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs;
 * import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("cloudfront.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("cloudfront-realtime-log-config-example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "kinesis:DescribeStreamSummary",
 *                     "kinesis:DescribeStream",
 *                     "kinesis:PutRecord",
 *                     "kinesis:PutRecords")
 *                 .resources(exampleAwsKinesisStream.arn())
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .name("cloudfront-realtime-log-config-example")
 *             .role(exampleRole.id())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRealtimeLogConfig = new RealtimeLogConfig("exampleRealtimeLogConfig", RealtimeLogConfigArgs.builder()
 *             .name("example")
 *             .samplingRate(75)
 *             .fields(
 *                 "timestamp",
 *                 "c-ip")
 *             .endpoint(RealtimeLogConfigEndpointArgs.builder()
 *                 .streamType("Kinesis")
 *                 .kinesisStreamConfig(RealtimeLogConfigEndpointKinesisStreamConfigArgs.builder()
 *                     .roleArn(exampleRole.arn())
 *                     .streamArn(exampleAwsKinesisStream.arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: cloudfront-realtime-log-config-example
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       name: cloudfront-realtime-log-config-example
 *       role: ${exampleRole.id}
 *       policy: ${example.json}
 *   exampleRealtimeLogConfig:
 *     type: aws:cloudfront:RealtimeLogConfig
 *     name: example
 *     properties:
 *       name: example
 *       samplingRate: 75
 *       fields:
 *         - timestamp
 *         - c-ip
 *       endpoint:
 *         streamType: Kinesis
 *         kinesisStreamConfig:
 *           roleArn: ${exampleRole.arn}
 *           streamArn: ${exampleAwsKinesisStream.arn}
 *     options:
 *       dependson:
 *         - ${exampleRolePolicy}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - cloudfront.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - kinesis:DescribeStreamSummary
 *               - kinesis:DescribeStream
 *               - kinesis:PutRecord
 *               - kinesis:PutRecords
 *             resources:
 *               - ${exampleAwsKinesisStream.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudFront real-time log configurations using the ARN. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/realtimeLogConfig:RealtimeLogConfig example arn:aws:cloudfront::111122223333:realtime-log-config/ExampleNameForRealtimeLogConfig
 * ```
 * @property endpoint The Amazon Kinesis data streams where real-time log data is sent.
 * @property fields The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
 * @property name The unique name to identify this real-time log configuration.
 * @property samplingRate The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
 */
public data class RealtimeLogConfigArgs(
    public val endpoint: Output<RealtimeLogConfigEndpointArgs>? = null,
    public val fields: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val samplingRate: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.RealtimeLogConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.RealtimeLogConfigArgs =
        com.pulumi.aws.cloudfront.RealtimeLogConfigArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .samplingRate(samplingRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RealtimeLogConfigArgs].
 */
@PulumiTagMarker
public class RealtimeLogConfigArgsBuilder internal constructor() {
    private var endpoint: Output<RealtimeLogConfigEndpointArgs>? = null

    private var fields: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var samplingRate: Output<Int>? = null

    /**
     * @param value The Amazon Kinesis data streams where real-time log data is sent.
     */
    @JvmName("bdnihuqcexnivkdw")
    public suspend fun endpoint(`value`: Output<RealtimeLogConfigEndpointArgs>) {
        this.endpoint = value
    }

    /**
     * @param value The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("yuguudexktcbdbuo")
    public suspend fun fields(`value`: Output<List<String>>) {
        this.fields = value
    }

    @JvmName("byawwuqecvdpbhdq")
    public suspend fun fields(vararg values: Output<String>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("nkxauwtxkmitnqux")
    public suspend fun fields(values: List<Output<String>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value The unique name to identify this real-time log configuration.
     */
    @JvmName("sogyaenctrtwqdmm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     */
    @JvmName("bmlcobsdrsuxetfx")
    public suspend fun samplingRate(`value`: Output<Int>) {
        this.samplingRate = value
    }

    /**
     * @param value The Amazon Kinesis data streams where real-time log data is sent.
     */
    @JvmName("bppwibsnnaojkceh")
    public suspend fun endpoint(`value`: RealtimeLogConfigEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param argument The Amazon Kinesis data streams where real-time log data is sent.
     */
    @JvmName("buacjmveqbtyslia")
    public suspend fun endpoint(argument: suspend RealtimeLogConfigEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = RealtimeLogConfigEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpoint = mapped
    }

    /**
     * @param value The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("oybuaadetoohgsxj")
    public suspend fun fields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param values The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     */
    @JvmName("rdbsfentcgedhbqw")
    public suspend fun fields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value The unique name to identify this real-time log configuration.
     */
    @JvmName("puqdyplbrbceavid")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     */
    @JvmName("mkprqhsibxtljmtq")
    public suspend fun samplingRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingRate = mapped
    }

    internal fun build(): RealtimeLogConfigArgs = RealtimeLogConfigArgs(
        endpoint = endpoint,
        fields = fields,
        name = name,
        samplingRate = samplingRate,
    )
}
