@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin

import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs.builder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCorsConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCorsConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyCustomHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicySecurityHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicySecurityHeadersConfigArgsBuilder
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs
import com.pulumi.aws.cloudfront.kotlin.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a CloudFront response headers policy resource.
 * A response headers policy contains information about a set of HTTP response headers and their values.
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution.
 * When it’s attached to a cache behavior, CloudFront adds the headers in the policy to every response that it sends for requests that match the cache behavior.
 * ## Example Usage
 * The example below creates a CloudFront response headers policy.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.ResponseHeadersPolicy("example", {
 *     name: "example-policy",
 *     comment: "test comment",
 *     corsConfig: {
 *         accessControlAllowCredentials: true,
 *         accessControlAllowHeaders: {
 *             items: ["test"],
 *         },
 *         accessControlAllowMethods: {
 *             items: ["GET"],
 *         },
 *         accessControlAllowOrigins: {
 *             items: ["test&#46;example&#46;comtest"],
 *         },
 *         originOverride: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.ResponseHeadersPolicy("example",
 *     name="example-policy",
 *     comment="test comment",
 *     cors_config={
 *         "access_control_allow_credentials": True,
 *         "access_control_allow_headers": {
 *             "items": ["test"],
 *         },
 *         "access_control_allow_methods": {
 *             "items": ["GET"],
 *         },
 *         "access_control_allow_origins": {
 *             "items": ["test&#46;example&#46;comtest"],
 *         },
 *         "origin_override": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.ResponseHeadersPolicy("example", new()
 *     {
 *         Name = "example-policy",
 *         Comment = "test comment",
 *         CorsConfig = new Aws.CloudFront.Inputs.ResponseHeadersPolicyCorsConfigArgs
 *         {
 *             AccessControlAllowCredentials = true,
 *             AccessControlAllowHeaders = new Aws.CloudFront.Inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs
 *             {
 *                 Items = new[]
 *                 {
 *                     "test",
 *                 },
 *             },
 *             AccessControlAllowMethods = new Aws.CloudFront.Inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs
 *             {
 *                 Items = new[]
 *                 {
 *                     "GET",
 *                 },
 *             },
 *             AccessControlAllowOrigins = new Aws.CloudFront.Inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs
 *             {
 *                 Items = new[]
 *                 {
 *                     "test.example.comtest",
 *                 },
 *             },
 *             OriginOverride = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewResponseHeadersPolicy(ctx, "example", &cloudfront.ResponseHeadersPolicyArgs{
 * 			Name:    pulumi.String("example-policy"),
 * 			Comment: pulumi.String("test comment"),
 * 			CorsConfig: &cloudfront.ResponseHeadersPolicyCorsConfigArgs{
 * 				AccessControlAllowCredentials: pulumi.Bool(true),
 * 				AccessControlAllowHeaders: &cloudfront.ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs{
 * 					Items: pulumi.StringArray{
 * 						pulumi.String("test"),
 * 					},
 * 				},
 * 				AccessControlAllowMethods: &cloudfront.ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs{
 * 					Items: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 					},
 * 				},
 * 				AccessControlAllowOrigins: &cloudfront.ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs{
 * 					Items: pulumi.StringArray{
 * 						pulumi.String("test.example.comtest"),
 * 					},
 * 				},
 * 				OriginOverride: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy("example", ResponseHeadersPolicyArgs.builder()
 *             .name("example-policy")
 *             .comment("test comment")
 *             .corsConfig(ResponseHeadersPolicyCorsConfigArgs.builder()
 *                 .accessControlAllowCredentials(true)
 *                 .accessControlAllowHeaders(ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs.builder()
 *                     .items("test")
 *                     .build())
 *                 .accessControlAllowMethods(ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs.builder()
 *                     .items("GET")
 *                     .build())
 *                 .accessControlAllowOrigins(ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs.builder()
 *                     .items("test.example.comtest")
 *                     .build())
 *                 .originOverride(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:ResponseHeadersPolicy
 *     properties:
 *       name: example-policy
 *       comment: test comment
 *       corsConfig:
 *         accessControlAllowCredentials: true
 *         accessControlAllowHeaders:
 *           items:
 *             - test
 *         accessControlAllowMethods:
 *           items:
 *             - GET
 *         accessControlAllowOrigins:
 *           items:
 *             - test.example.comtest
 *         originOverride: true
 * ```
 * <!--End PulumiCodeChooser -->
 * The example below creates a CloudFront response headers policy with a custom headers config.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.ResponseHeadersPolicy("example", {
 *     name: "example-headers-policy",
 *     customHeadersConfig: {
 *         items: [
 *             {
 *                 header: "X-Permitted-Cross-Domain-Policies",
 *                 override: true,
 *                 value: "none",
 *             },
 *             {
 *                 header: "X-Test",
 *                 override: true,
 *                 value: "none",
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.ResponseHeadersPolicy("example",
 *     name="example-headers-policy",
 *     custom_headers_config={
 *         "items": [
 *             {
 *                 "header": "X-Permitted-Cross-Domain-Policies",
 *                 "override": True,
 *                 "value": "none",
 *             },
 *             {
 *                 "header": "X-Test",
 *                 "override": True,
 *                 "value": "none",
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.ResponseHeadersPolicy("example", new()
 *     {
 *         Name = "example-headers-policy",
 *         CustomHeadersConfig = new Aws.CloudFront.Inputs.ResponseHeadersPolicyCustomHeadersConfigArgs
 *         {
 *             Items = new[]
 *             {
 *                 new Aws.CloudFront.Inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs
 *                 {
 *                     Header = "X-Permitted-Cross-Domain-Policies",
 *                     Override = true,
 *                     Value = "none",
 *                 },
 *                 new Aws.CloudFront.Inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs
 *                 {
 *                     Header = "X-Test",
 *                     Override = true,
 *                     Value = "none",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewResponseHeadersPolicy(ctx, "example", &cloudfront.ResponseHeadersPolicyArgs{
 * 			Name: pulumi.String("example-headers-policy"),
 * 			CustomHeadersConfig: &cloudfront.ResponseHeadersPolicyCustomHeadersConfigArgs{
 * 				Items: cloudfront.ResponseHeadersPolicyCustomHeadersConfigItemArray{
 * 					&cloudfront.ResponseHeadersPolicyCustomHeadersConfigItemArgs{
 * 						Header:   pulumi.String("X-Permitted-Cross-Domain-Policies"),
 * 						Override: pulumi.Bool(true),
 * 						Value:    pulumi.String("none"),
 * 					},
 * 					&cloudfront.ResponseHeadersPolicyCustomHeadersConfigItemArgs{
 * 						Header:   pulumi.String("X-Test"),
 * 						Override: pulumi.Bool(true),
 * 						Value:    pulumi.String("none"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy("example", ResponseHeadersPolicyArgs.builder()
 *             .name("example-headers-policy")
 *             .customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfigArgs.builder()
 *                 .items(
 *                     ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
 *                         .header("X-Permitted-Cross-Domain-Policies")
 *                         .override(true)
 *                         .value("none")
 *                         .build(),
 *                     ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
 *                         .header("X-Test")
 *                         .override(true)
 *                         .value("none")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:ResponseHeadersPolicy
 *     properties:
 *       name: example-headers-policy
 *       customHeadersConfig:
 *         items:
 *           - header: X-Permitted-Cross-Domain-Policies
 *             override: true
 *             value: none
 *           - header: X-Test
 *             override: true
 *             value: none
 * ```
 * <!--End PulumiCodeChooser -->
 * The example below creates a CloudFront response headers policy with a custom headers config and server timing headers config.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudfront.ResponseHeadersPolicy("example", {
 *     name: "example-headers-policy",
 *     customHeadersConfig: {
 *         items: [{
 *             header: "X-Permitted-Cross-Domain-Policies",
 *             override: true,
 *             value: "none",
 *         }],
 *     },
 *     serverTimingHeadersConfig: {
 *         enabled: true,
 *         samplingRate: 50,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudfront.ResponseHeadersPolicy("example",
 *     name="example-headers-policy",
 *     custom_headers_config={
 *         "items": [{
 *             "header": "X-Permitted-Cross-Domain-Policies",
 *             "override": True,
 *             "value": "none",
 *         }],
 *     },
 *     server_timing_headers_config={
 *         "enabled": True,
 *         "sampling_rate": 50,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudFront.ResponseHeadersPolicy("example", new()
 *     {
 *         Name = "example-headers-policy",
 *         CustomHeadersConfig = new Aws.CloudFront.Inputs.ResponseHeadersPolicyCustomHeadersConfigArgs
 *         {
 *             Items = new[]
 *             {
 *                 new Aws.CloudFront.Inputs.ResponseHeadersPolicyCustomHeadersConfigItemArgs
 *                 {
 *                     Header = "X-Permitted-Cross-Domain-Policies",
 *                     Override = true,
 *                     Value = "none",
 *                 },
 *             },
 *         },
 *         ServerTimingHeadersConfig = new Aws.CloudFront.Inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs
 *         {
 *             Enabled = true,
 *             SamplingRate = 50,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudfront"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudfront.NewResponseHeadersPolicy(ctx, "example", &cloudfront.ResponseHeadersPolicyArgs{
 * 			Name: pulumi.String("example-headers-policy"),
 * 			CustomHeadersConfig: &cloudfront.ResponseHeadersPolicyCustomHeadersConfigArgs{
 * 				Items: cloudfront.ResponseHeadersPolicyCustomHeadersConfigItemArray{
 * 					&cloudfront.ResponseHeadersPolicyCustomHeadersConfigItemArgs{
 * 						Header:   pulumi.String("X-Permitted-Cross-Domain-Policies"),
 * 						Override: pulumi.Bool(true),
 * 						Value:    pulumi.String("none"),
 * 					},
 * 				},
 * 			},
 * 			ServerTimingHeadersConfig: &cloudfront.ResponseHeadersPolicyServerTimingHeadersConfigArgs{
 * 				Enabled:      pulumi.Bool(true),
 * 				SamplingRate: pulumi.Float64(50),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy("example", ResponseHeadersPolicyArgs.builder()
 *             .name("example-headers-policy")
 *             .customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfigArgs.builder()
 *                 .items(ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
 *                     .header("X-Permitted-Cross-Domain-Policies")
 *                     .override(true)
 *                     .value("none")
 *                     .build())
 *                 .build())
 *             .serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfigArgs.builder()
 *                 .enabled(true)
 *                 .samplingRate(50)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudfront:ResponseHeadersPolicy
 *     properties:
 *       name: example-headers-policy
 *       customHeadersConfig:
 *         items:
 *           - header: X-Permitted-Cross-Domain-Policies
 *             override: true
 *             value: none
 *       serverTimingHeadersConfig:
 *         enabled: true
 *         samplingRate: 50
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cloudfront Response Headers Policies using the `id`. For example:
 * ```sh
 * $ pulumi import aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy policy 658327ea-f89d-4fab-a63d-7e88639e58f9
 * ```
 * @property comment A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
 * @property corsConfig A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
 * @property customHeadersConfig Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
 * @property etag The current version of the response headers policy.
 * @property name A unique name to identify the response headers policy.
 * @property removeHeadersConfig A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
 * @property securityHeadersConfig A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
 * @property serverTimingHeadersConfig A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
 */
public data class ResponseHeadersPolicyArgs(
    public val comment: Output<String>? = null,
    public val corsConfig: Output<ResponseHeadersPolicyCorsConfigArgs>? = null,
    public val customHeadersConfig: Output<ResponseHeadersPolicyCustomHeadersConfigArgs>? = null,
    public val etag: Output<String>? = null,
    public val name: Output<String>? = null,
    public val removeHeadersConfig: Output<ResponseHeadersPolicyRemoveHeadersConfigArgs>? = null,
    public val securityHeadersConfig: Output<ResponseHeadersPolicySecurityHeadersConfigArgs>? = null,
    public val serverTimingHeadersConfig: Output<ResponseHeadersPolicyServerTimingHeadersConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs =
        com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .corsConfig(corsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customHeadersConfig(
                customHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .removeHeadersConfig(
                removeHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityHeadersConfig(
                securityHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serverTimingHeadersConfig(
                serverTimingHeadersConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ResponseHeadersPolicyArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var corsConfig: Output<ResponseHeadersPolicyCorsConfigArgs>? = null

    private var customHeadersConfig: Output<ResponseHeadersPolicyCustomHeadersConfigArgs>? = null

    private var etag: Output<String>? = null

    private var name: Output<String>? = null

    private var removeHeadersConfig: Output<ResponseHeadersPolicyRemoveHeadersConfigArgs>? = null

    private var securityHeadersConfig: Output<ResponseHeadersPolicySecurityHeadersConfigArgs>? = null

    private var serverTimingHeadersConfig: Output<ResponseHeadersPolicyServerTimingHeadersConfigArgs>? =
        null

    /**
     * @param value A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     */
    @JvmName("hqwcxclouxhvwgvg")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    @JvmName("tvmrqhbuwapircoa")
    public suspend fun corsConfig(`value`: Output<ResponseHeadersPolicyCorsConfigArgs>) {
        this.corsConfig = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    @JvmName("kmiujesuyutsmwby")
    public suspend fun customHeadersConfig(`value`: Output<ResponseHeadersPolicyCustomHeadersConfigArgs>) {
        this.customHeadersConfig = value
    }

    /**
     * @param value The current version of the response headers policy.
     */
    @JvmName("rtbdqcwloxwcepxr")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value A unique name to identify the response headers policy.
     */
    @JvmName("edcjgpthbiubrrpe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    @JvmName("qufsqfyotwsjpccc")
    public suspend fun removeHeadersConfig(`value`: Output<ResponseHeadersPolicyRemoveHeadersConfigArgs>) {
        this.removeHeadersConfig = value
    }

    /**
     * @param value A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    @JvmName("qgoncoodtugywghj")
    public suspend fun securityHeadersConfig(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigArgs>) {
        this.securityHeadersConfig = value
    }

    /**
     * @param value A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    @JvmName("tithlqbuggdnobqo")
    public suspend fun serverTimingHeadersConfig(`value`: Output<ResponseHeadersPolicyServerTimingHeadersConfigArgs>) {
        this.serverTimingHeadersConfig = value
    }

    /**
     * @param value A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     */
    @JvmName("pkqvxapmnsjtmgih")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    @JvmName("meesfyqbhpikaeos")
    public suspend fun corsConfig(`value`: ResponseHeadersPolicyCorsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsConfig = mapped
    }

    /**
     * @param argument A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     */
    @JvmName("wdxkfowrncsljujt")
    public suspend fun corsConfig(argument: suspend ResponseHeadersPolicyCorsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyCorsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsConfig = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    @JvmName("hfgrhslxkbndgyei")
    public suspend fun customHeadersConfig(`value`: ResponseHeadersPolicyCustomHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeadersConfig = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     */
    @JvmName("lsmjbajhfiqiumig")
    public suspend fun customHeadersConfig(argument: suspend ResponseHeadersPolicyCustomHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyCustomHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customHeadersConfig = mapped
    }

    /**
     * @param value The current version of the response headers policy.
     */
    @JvmName("pcknltdtjcrjkbhm")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value A unique name to identify the response headers policy.
     */
    @JvmName("wqxejpvpmsagvlfa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    @JvmName("scqcktgtbiwrjtdc")
    public suspend fun removeHeadersConfig(`value`: ResponseHeadersPolicyRemoveHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.removeHeadersConfig = mapped
    }

    /**
     * @param argument A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     */
    @JvmName("vaqgrdgesnkloaag")
    public suspend fun removeHeadersConfig(argument: suspend ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyRemoveHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.removeHeadersConfig = mapped
    }

    /**
     * @param value A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    @JvmName("ecmgnsrdanmmovpv")
    public suspend fun securityHeadersConfig(`value`: ResponseHeadersPolicySecurityHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityHeadersConfig = mapped
    }

    /**
     * @param argument A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     */
    @JvmName("jwctorxxpitweqgm")
    public suspend fun securityHeadersConfig(argument: suspend ResponseHeadersPolicySecurityHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicySecurityHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityHeadersConfig = mapped
    }

    /**
     * @param value A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    @JvmName("wupxhgqjcavjkffs")
    public suspend fun serverTimingHeadersConfig(`value`: ResponseHeadersPolicyServerTimingHeadersConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverTimingHeadersConfig = mapped
    }

    /**
     * @param argument A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     */
    @JvmName("rpiqpucjuanvreva")
    public suspend fun serverTimingHeadersConfig(argument: suspend ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ResponseHeadersPolicyServerTimingHeadersConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverTimingHeadersConfig = mapped
    }

    internal fun build(): ResponseHeadersPolicyArgs = ResponseHeadersPolicyArgs(
        comment = comment,
        corsConfig = corsConfig,
        customHeadersConfig = customHeadersConfig,
        etag = etag,
        name = name,
        removeHeadersConfig = removeHeadersConfig,
        securityHeadersConfig = securityHeadersConfig,
        serverTimingHeadersConfig = serverTimingHeadersConfig,
    )
}
