@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property queryStringBehavior Whether URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `query_string_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
 * @property queryStrings Configuration parameter that contains a list of query string names. See Items for more information.
 */
public data class CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs(
    public val queryStringBehavior: Output<String>,
    public val queryStrings: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs =
        com.pulumi.aws.cloudfront.inputs.CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs.builder()
            .queryStringBehavior(queryStringBehavior.applyValue({ args0 -> args0 }))
            .queryStrings(queryStrings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs].
 */
@PulumiTagMarker
public class CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgsBuilder
internal constructor() {
    private var queryStringBehavior: Output<String>? = null

    private var queryStrings:
        Output<CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs>? =
        null

    /**
     * @param value Whether URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `query_string_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
     */
    @JvmName("asiiosymnocfgaqi")
    public suspend fun queryStringBehavior(`value`: Output<String>) {
        this.queryStringBehavior = value
    }

    /**
     * @param value Configuration parameter that contains a list of query string names. See Items for more information.
     */
    @JvmName("wrboqiuqnnovjhgp")
    public suspend fun queryStrings(`value`: Output<CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs>) {
        this.queryStrings = value
    }

    /**
     * @param value Whether URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values for `query_string_behavior` are `none`, `whitelist`, `allExcept`, and `all`.
     */
    @JvmName("kfyfewkhkfgsldqa")
    public suspend fun queryStringBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringBehavior = mapped
    }

    /**
     * @param value Configuration parameter that contains a list of query string names. See Items for more information.
     */
    @JvmName("ndoxuywjbmmuwgqy")
    public suspend fun queryStrings(`value`: CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    /**
     * @param argument Configuration parameter that contains a list of query string names. See Items for more information.
     */
    @JvmName("yiwoegxruradvkbi")
    public suspend fun queryStrings(argument: suspend CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgsBuilder.() -> Unit) {
        val toBeMapped =
            CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    internal fun build(): CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs =
        CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs(
            queryStringBehavior = queryStringBehavior ?: throw PulumiNullFieldException("queryStringBehavior"),
            queryStrings = queryStrings,
        )
}
