@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property items A list of CloudFront domain names for the staging distribution.
 * @property quantity Number of CloudFront domain names in the staging distribution.
 */
public data class ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
    public val items: Output<List<String>>? = null,
    public val quantity: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs =
        com.pulumi.aws.cloudfront.inputs.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs.builder()
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .quantity(quantity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs].
 */
@PulumiTagMarker
public class ContinuousDeploymentPolicyStagingDistributionDnsNamesArgsBuilder internal constructor() {
    private var items: Output<List<String>>? = null

    private var quantity: Output<Int>? = null

    /**
     * @param value A list of CloudFront domain names for the staging distribution.
     */
    @JvmName("xlsolvwcmwtcecmv")
    public suspend fun items(`value`: Output<List<String>>) {
        this.items = value
    }

    @JvmName("irfnjgitajpnrgvq")
    public suspend fun items(vararg values: Output<String>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values A list of CloudFront domain names for the staging distribution.
     */
    @JvmName("mvoyxfjxlhqfllsu")
    public suspend fun items(values: List<Output<String>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value Number of CloudFront domain names in the staging distribution.
     */
    @JvmName("ofyqwknirlbugxij")
    public suspend fun quantity(`value`: Output<Int>) {
        this.quantity = value
    }

    /**
     * @param value A list of CloudFront domain names for the staging distribution.
     */
    @JvmName("ovmfiwahgxcihktg")
    public suspend fun items(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param values A list of CloudFront domain names for the staging distribution.
     */
    @JvmName("smvhnrjrpgdgvdsc")
    public suspend fun items(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value Number of CloudFront domain names in the staging distribution.
     */
    @JvmName("ymaairekdrieimyi")
    public suspend fun quantity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    internal fun build(): ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs =
        ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
            items = items,
            quantity = quantity ?: throw PulumiNullFieldException("quantity"),
        )
}
