@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionCustomErrorResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property errorCachingMinTtl Minimum amount of time you want HTTP error codes to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated.
 * @property errorCode 4xx or 5xx HTTP status code that you want to customize.
 * @property responseCode HTTP status code that you want CloudFront to return with the custom error page to the viewer.
 * @property responsePagePath Path of the custom error page (for example, `/custom_404.html`).
 */
public data class DistributionCustomErrorResponseArgs(
    public val errorCachingMinTtl: Output<Int>? = null,
    public val errorCode: Output<Int>,
    public val responseCode: Output<Int>? = null,
    public val responsePagePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionCustomErrorResponseArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionCustomErrorResponseArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionCustomErrorResponseArgs.builder()
            .errorCachingMinTtl(errorCachingMinTtl?.applyValue({ args0 -> args0 }))
            .errorCode(errorCode.applyValue({ args0 -> args0 }))
            .responseCode(responseCode?.applyValue({ args0 -> args0 }))
            .responsePagePath(responsePagePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionCustomErrorResponseArgs].
 */
@PulumiTagMarker
public class DistributionCustomErrorResponseArgsBuilder internal constructor() {
    private var errorCachingMinTtl: Output<Int>? = null

    private var errorCode: Output<Int>? = null

    private var responseCode: Output<Int>? = null

    private var responsePagePath: Output<String>? = null

    /**
     * @param value Minimum amount of time you want HTTP error codes to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated.
     */
    @JvmName("uejuidpcnjxuhmlg")
    public suspend fun errorCachingMinTtl(`value`: Output<Int>) {
        this.errorCachingMinTtl = value
    }

    /**
     * @param value 4xx or 5xx HTTP status code that you want to customize.
     */
    @JvmName("iiyjejrapmmpotbt")
    public suspend fun errorCode(`value`: Output<Int>) {
        this.errorCode = value
    }

    /**
     * @param value HTTP status code that you want CloudFront to return with the custom error page to the viewer.
     */
    @JvmName("kttfabnfenqwijvl")
    public suspend fun responseCode(`value`: Output<Int>) {
        this.responseCode = value
    }

    /**
     * @param value Path of the custom error page (for example, `/custom_404.html`).
     */
    @JvmName("yqmtubrobprffdsb")
    public suspend fun responsePagePath(`value`: Output<String>) {
        this.responsePagePath = value
    }

    /**
     * @param value Minimum amount of time you want HTTP error codes to stay in CloudFront caches before CloudFront queries your origin to see whether the object has been updated.
     */
    @JvmName("awjiuqqstdhknnaj")
    public suspend fun errorCachingMinTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorCachingMinTtl = mapped
    }

    /**
     * @param value 4xx or 5xx HTTP status code that you want to customize.
     */
    @JvmName("tbllcnsyijavionj")
    public suspend fun errorCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value HTTP status code that you want CloudFront to return with the custom error page to the viewer.
     */
    @JvmName("ovwwajtesxcmqoxp")
    public suspend fun responseCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCode = mapped
    }

    /**
     * @param value Path of the custom error page (for example, `/custom_404.html`).
     */
    @JvmName("nsujbpvqxciwlcoj")
    public suspend fun responsePagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responsePagePath = mapped
    }

    internal fun build(): DistributionCustomErrorResponseArgs = DistributionCustomErrorResponseArgs(
        errorCachingMinTtl = errorCachingMinTtl,
        errorCode = errorCode ?: throw PulumiNullFieldException("errorCode"),
        responseCode = responseCode,
        responsePagePath = responsePagePath,
    )
}
