@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cookies The forwarded values cookies that specifies how CloudFront handles cookies (maximum one).
 * @property headers Headers, if any, that you want CloudFront to vary upon for this cache behavior. Specify `*` to include all headers.
 * @property queryString Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior.
 * @property queryStringCacheKeys When specified, along with a value of `true` for `query_string`, all query strings are forwarded, however only the query string keys listed in this argument are cached. When omitted with a value of `true` for `query_string`, all query string keys are cached.
 */
public data class DistributionDefaultCacheBehaviorForwardedValuesArgs(
    public val cookies: Output<DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs>,
    public val headers: Output<List<String>>? = null,
    public val queryString: Output<Boolean>,
    public val queryStringCacheKeys: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorForwardedValuesArgs.builder()
            .cookies(cookies.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .queryString(queryString.applyValue({ args0 -> args0 }))
            .queryStringCacheKeys(
                queryStringCacheKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionDefaultCacheBehaviorForwardedValuesArgs].
 */
@PulumiTagMarker
public class DistributionDefaultCacheBehaviorForwardedValuesArgsBuilder internal constructor() {
    private var cookies: Output<DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs>? = null

    private var headers: Output<List<String>>? = null

    private var queryString: Output<Boolean>? = null

    private var queryStringCacheKeys: Output<List<String>>? = null

    /**
     * @param value The forwarded values cookies that specifies how CloudFront handles cookies (maximum one).
     */
    @JvmName("guvrirlpcryocvsq")
    public suspend fun cookies(`value`: Output<DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Headers, if any, that you want CloudFront to vary upon for this cache behavior. Specify `*` to include all headers.
     */
    @JvmName("gapcrbykbqyxnrsd")
    public suspend fun headers(`value`: Output<List<String>>) {
        this.headers = value
    }

    @JvmName("dhcfbhpanuavenqi")
    public suspend fun headers(vararg values: Output<String>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Headers, if any, that you want CloudFront to vary upon for this cache behavior. Specify `*` to include all headers.
     */
    @JvmName("xbdxeyerlmywdjvl")
    public suspend fun headers(values: List<Output<String>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior.
     */
    @JvmName("nmyoparvqnmjaidr")
    public suspend fun queryString(`value`: Output<Boolean>) {
        this.queryString = value
    }

    /**
     * @param value When specified, along with a value of `true` for `query_string`, all query strings are forwarded, however only the query string keys listed in this argument are cached. When omitted with a value of `true` for `query_string`, all query string keys are cached.
     */
    @JvmName("hfrnhoguahuwnypd")
    public suspend fun queryStringCacheKeys(`value`: Output<List<String>>) {
        this.queryStringCacheKeys = value
    }

    @JvmName("kjllqxdesesbwrsv")
    public suspend fun queryStringCacheKeys(vararg values: Output<String>) {
        this.queryStringCacheKeys = Output.all(values.asList())
    }

    /**
     * @param values When specified, along with a value of `true` for `query_string`, all query strings are forwarded, however only the query string keys listed in this argument are cached. When omitted with a value of `true` for `query_string`, all query string keys are cached.
     */
    @JvmName("unjkcfoxsvaxbhsq")
    public suspend fun queryStringCacheKeys(values: List<Output<String>>) {
        this.queryStringCacheKeys = Output.all(values)
    }

    /**
     * @param value The forwarded values cookies that specifies how CloudFront handles cookies (maximum one).
     */
    @JvmName("ddcspjuyeubyclmb")
    public suspend fun cookies(`value`: DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument The forwarded values cookies that specifies how CloudFront handles cookies (maximum one).
     */
    @JvmName("vlyswbshdrgddkdx")
    public suspend fun cookies(argument: suspend DistributionDefaultCacheBehaviorForwardedValuesCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionDefaultCacheBehaviorForwardedValuesCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Headers, if any, that you want CloudFront to vary upon for this cache behavior. Specify `*` to include all headers.
     */
    @JvmName("niklbfefcvsioxio")
    public suspend fun headers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values Headers, if any, that you want CloudFront to vary upon for this cache behavior. Specify `*` to include all headers.
     */
    @JvmName("ymdjiflglvawimwm")
    public suspend fun headers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior.
     */
    @JvmName("iwyooqdygubsxkip")
    public suspend fun queryString(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param value When specified, along with a value of `true` for `query_string`, all query strings are forwarded, however only the query string keys listed in this argument are cached. When omitted with a value of `true` for `query_string`, all query string keys are cached.
     */
    @JvmName("ittyxfmqokgdihvy")
    public suspend fun queryStringCacheKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringCacheKeys = mapped
    }

    /**
     * @param values When specified, along with a value of `true` for `query_string`, all query strings are forwarded, however only the query string keys listed in this argument are cached. When omitted with a value of `true` for `query_string`, all query string keys are cached.
     */
    @JvmName("ljxmodrypymmvktp")
    public suspend fun queryStringCacheKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringCacheKeys = mapped
    }

    internal fun build(): DistributionDefaultCacheBehaviorForwardedValuesArgs =
        DistributionDefaultCacheBehaviorForwardedValuesArgs(
            cookies = cookies ?: throw PulumiNullFieldException("cookies"),
            headers = headers,
            queryString = queryString ?: throw PulumiNullFieldException("queryString"),
            queryStringCacheKeys = queryStringCacheKeys,
        )
}
