@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorFunctionAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventType Specific event to trigger this function. Valid values: `viewer-request` or `viewer-response`.
 * @property functionArn ARN of the CloudFront function.
 */
public data class DistributionDefaultCacheBehaviorFunctionAssociationArgs(
    public val eventType: Output<String>,
    public val functionArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorFunctionAssociationArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorFunctionAssociationArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorFunctionAssociationArgs.builder()
            .eventType(eventType.applyValue({ args0 -> args0 }))
            .functionArn(functionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionDefaultCacheBehaviorFunctionAssociationArgs].
 */
@PulumiTagMarker
public class DistributionDefaultCacheBehaviorFunctionAssociationArgsBuilder internal constructor() {
    private var eventType: Output<String>? = null

    private var functionArn: Output<String>? = null

    /**
     * @param value Specific event to trigger this function. Valid values: `viewer-request` or `viewer-response`.
     */
    @JvmName("rcmlkyjcpekhoosf")
    public suspend fun eventType(`value`: Output<String>) {
        this.eventType = value
    }

    /**
     * @param value ARN of the CloudFront function.
     */
    @JvmName("trkrvqhrmeenvrrv")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value Specific event to trigger this function. Valid values: `viewer-request` or `viewer-response`.
     */
    @JvmName("mfsrxrsulotascnh")
    public suspend fun eventType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventType = mapped
    }

    /**
     * @param value ARN of the CloudFront function.
     */
    @JvmName("lpafjlniesuscrxu")
    public suspend fun functionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    internal fun build(): DistributionDefaultCacheBehaviorFunctionAssociationArgs =
        DistributionDefaultCacheBehaviorFunctionAssociationArgs(
            eventType = eventType ?: throw PulumiNullFieldException("eventType"),
            functionArn = functionArn ?: throw PulumiNullFieldException("functionArn"),
        )
}
