@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventType Specific event to trigger this function. Valid values: `viewer-request`, `origin-request`, `viewer-response`, `origin-response`.
 * @property includeBody When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
 * @property lambdaArn ARN of the Lambda function.
 */
public data class DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs(
    public val eventType: Output<String>,
    public val includeBody: Output<Boolean>? = null,
    public val lambdaArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs.builder()
            .eventType(eventType.applyValue({ args0 -> args0 }))
            .includeBody(includeBody?.applyValue({ args0 -> args0 }))
            .lambdaArn(lambdaArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs].
 */
@PulumiTagMarker
public class DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgsBuilder internal constructor() {
    private var eventType: Output<String>? = null

    private var includeBody: Output<Boolean>? = null

    private var lambdaArn: Output<String>? = null

    /**
     * @param value Specific event to trigger this function. Valid values: `viewer-request`, `origin-request`, `viewer-response`, `origin-response`.
     */
    @JvmName("ilkkbgrolsdfxlul")
    public suspend fun eventType(`value`: Output<String>) {
        this.eventType = value
    }

    /**
     * @param value When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
     */
    @JvmName("iqhjrfefpqbpehve")
    public suspend fun includeBody(`value`: Output<Boolean>) {
        this.includeBody = value
    }

    /**
     * @param value ARN of the Lambda function.
     */
    @JvmName("xlnncsobmbqgkmqx")
    public suspend fun lambdaArn(`value`: Output<String>) {
        this.lambdaArn = value
    }

    /**
     * @param value Specific event to trigger this function. Valid values: `viewer-request`, `origin-request`, `viewer-response`, `origin-response`.
     */
    @JvmName("yumvsaimmsglwjqg")
    public suspend fun eventType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventType = mapped
    }

    /**
     * @param value When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
     */
    @JvmName("kxfbahmfhmiqhxws")
    public suspend fun includeBody(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeBody = mapped
    }

    /**
     * @param value ARN of the Lambda function.
     */
    @JvmName("ahaowegjuacnsrvc")
    public suspend fun lambdaArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaArn = mapped
    }

    internal fun build(): DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs =
        DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs(
            eventType = eventType ?: throw PulumiNullFieldException("eventType"),
            includeBody = includeBody,
            lambdaArn = lambdaArn ?: throw PulumiNullFieldException("lambdaArn"),
        )
}
