@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property forward Whether you want CloudFront to forward cookies to the origin that is associated with this cache behavior. You can specify `all`, `none` or `whitelist`. If `whitelist`, you must include the subsequent `whitelisted_names`.
 * @property whitelistedNames If you have specified `whitelist` to `forward`, the whitelisted cookies that you want CloudFront to forward to your origin.
 */
public data class DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs(
    public val forward: Output<String>,
    public val whitelistedNames: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs.builder()
            .forward(forward.applyValue({ args0 -> args0 }))
            .whitelistedNames(whitelistedNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs].
 */
@PulumiTagMarker
public class DistributionOrderedCacheBehaviorForwardedValuesCookiesArgsBuilder internal constructor() {
    private var forward: Output<String>? = null

    private var whitelistedNames: Output<List<String>>? = null

    /**
     * @param value Whether you want CloudFront to forward cookies to the origin that is associated with this cache behavior. You can specify `all`, `none` or `whitelist`. If `whitelist`, you must include the subsequent `whitelisted_names`.
     */
    @JvmName("wqwspvhqbkfgjmxb")
    public suspend fun forward(`value`: Output<String>) {
        this.forward = value
    }

    /**
     * @param value If you have specified `whitelist` to `forward`, the whitelisted cookies that you want CloudFront to forward to your origin.
     */
    @JvmName("pxyerentopsxafwa")
    public suspend fun whitelistedNames(`value`: Output<List<String>>) {
        this.whitelistedNames = value
    }

    @JvmName("fxhfrmaamphavdxi")
    public suspend fun whitelistedNames(vararg values: Output<String>) {
        this.whitelistedNames = Output.all(values.asList())
    }

    /**
     * @param values If you have specified `whitelist` to `forward`, the whitelisted cookies that you want CloudFront to forward to your origin.
     */
    @JvmName("hcdnusatpfgqlwrt")
    public suspend fun whitelistedNames(values: List<Output<String>>) {
        this.whitelistedNames = Output.all(values)
    }

    /**
     * @param value Whether you want CloudFront to forward cookies to the origin that is associated with this cache behavior. You can specify `all`, `none` or `whitelist`. If `whitelist`, you must include the subsequent `whitelisted_names`.
     */
    @JvmName("qeurrekbmpfosslt")
    public suspend fun forward(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forward = mapped
    }

    /**
     * @param value If you have specified `whitelist` to `forward`, the whitelisted cookies that you want CloudFront to forward to your origin.
     */
    @JvmName("jkybiaibutklitvf")
    public suspend fun whitelistedNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whitelistedNames = mapped
    }

    /**
     * @param values If you have specified `whitelist` to `forward`, the whitelisted cookies that you want CloudFront to forward to your origin.
     */
    @JvmName("hgneufgxnoobnpoh")
    public suspend fun whitelistedNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.whitelistedNames = mapped
    }

    internal fun build(): DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs =
        DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs(
            forward = forward ?: throw PulumiNullFieldException("forward"),
            whitelistedNames = whitelistedNames,
        )
}
