@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failoverCriteria The failover criteria for when to failover to the secondary origin.
 * @property members Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
 * @property originId
 */
public data class DistributionOriginGroupArgs(
    public val failoverCriteria: Output<DistributionOriginGroupFailoverCriteriaArgs>,
    public val members: Output<List<DistributionOriginGroupMemberArgs>>,
    public val originId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupArgs.builder()
            .failoverCriteria(failoverCriteria.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .members(
                members.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .originId(originId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionOriginGroupArgs].
 */
@PulumiTagMarker
public class DistributionOriginGroupArgsBuilder internal constructor() {
    private var failoverCriteria: Output<DistributionOriginGroupFailoverCriteriaArgs>? = null

    private var members: Output<List<DistributionOriginGroupMemberArgs>>? = null

    private var originId: Output<String>? = null

    /**
     * @param value The failover criteria for when to failover to the secondary origin.
     */
    @JvmName("apngacxurckkfotv")
    public suspend fun failoverCriteria(`value`: Output<DistributionOriginGroupFailoverCriteriaArgs>) {
        this.failoverCriteria = value
    }

    /**
     * @param value Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("sddcrcdnilmubqck")
    public suspend fun members(`value`: Output<List<DistributionOriginGroupMemberArgs>>) {
        this.members = value
    }

    @JvmName("tdshcdxrtxgsfexs")
    public suspend fun members(vararg values: Output<DistributionOriginGroupMemberArgs>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("mlcxexrnkxxdfbar")
    public suspend fun members(values: List<Output<DistributionOriginGroupMemberArgs>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("jlowxnybiefnpyvi")
    public suspend fun originId(`value`: Output<String>) {
        this.originId = value
    }

    /**
     * @param value The failover criteria for when to failover to the secondary origin.
     */
    @JvmName("rsquglabhmjhcpue")
    public suspend fun failoverCriteria(`value`: DistributionOriginGroupFailoverCriteriaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverCriteria = mapped
    }

    /**
     * @param argument The failover criteria for when to failover to the secondary origin.
     */
    @JvmName("mbopijppddykbmsk")
    public suspend fun failoverCriteria(argument: suspend DistributionOriginGroupFailoverCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = DistributionOriginGroupFailoverCriteriaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.failoverCriteria = mapped
    }

    /**
     * @param value Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("pjqsopmshebbgego")
    public suspend fun members(`value`: List<DistributionOriginGroupMemberArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param argument Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("bsxxebfrlhwbbrdo")
    public suspend fun members(argument: List<suspend DistributionOriginGroupMemberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionOriginGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("rtdrsoxlubgkedxx")
    public suspend fun members(vararg argument: suspend DistributionOriginGroupMemberArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DistributionOriginGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("bniwylcemotpdbjr")
    public suspend fun members(argument: suspend DistributionOriginGroupMemberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionOriginGroupMemberArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param values Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
     */
    @JvmName("vrprxvgwvkfihlng")
    public suspend fun members(vararg values: DistributionOriginGroupMemberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param value
     */
    @JvmName("nktlawsjgyasnemr")
    public suspend fun originId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originId = mapped
    }

    internal fun build(): DistributionOriginGroupArgs = DistributionOriginGroupArgs(
        failoverCriteria = failoverCriteria ?: throw PulumiNullFieldException("failoverCriteria"),
        members = members ?: throw PulumiNullFieldException("members"),
        originId = originId ?: throw PulumiNullFieldException("originId"),
    )
}
