@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property originId
 */
public data class DistributionOriginGroupMemberArgs(
    public val originId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupMemberArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupMemberArgs =
        com.pulumi.aws.cloudfront.inputs.DistributionOriginGroupMemberArgs.builder()
            .originId(originId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionOriginGroupMemberArgs].
 */
@PulumiTagMarker
public class DistributionOriginGroupMemberArgsBuilder internal constructor() {
    private var originId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("mkfxcwgadwwjycth")
    public suspend fun originId(`value`: Output<String>) {
        this.originId = value
    }

    /**
     * @param value
     */
    @JvmName("cyixoohocooarvfq")
    public suspend fun originId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originId = mapped
    }

    internal fun build(): DistributionOriginGroupMemberArgs = DistributionOriginGroupMemberArgs(
        originId = originId ?: throw PulumiNullFieldException("originId"),
    )
}
