@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property locations [ISO 3166-1-alpha-2 codes][4] for which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`). If the type is specified as `none` an empty array can be used.
 * @property restrictionType Method that you want to use to restrict distribution of your content by country: `none`, `whitelist`, or `blacklist`.
 */
public data class DistributionRestrictionsGeoRestrictionArgs(
    public val locations: Output<List<String>>? = null,
    public val restrictionType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs = com.pulumi.aws.cloudfront.inputs.DistributionRestrictionsGeoRestrictionArgs.builder()
        .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .restrictionType(restrictionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionRestrictionsGeoRestrictionArgs].
 */
@PulumiTagMarker
public class DistributionRestrictionsGeoRestrictionArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var restrictionType: Output<String>? = null

    /**
     * @param value [ISO 3166-1-alpha-2 codes][4] for which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`). If the type is specified as `none` an empty array can be used.
     */
    @JvmName("iknxwqhyncyeywlp")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("uwxpjgksaqkqyooo")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values [ISO 3166-1-alpha-2 codes][4] for which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`). If the type is specified as `none` an empty array can be used.
     */
    @JvmName("pppvyfufmhprvdsd")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value Method that you want to use to restrict distribution of your content by country: `none`, `whitelist`, or `blacklist`.
     */
    @JvmName("urgalguufcodhtsv")
    public suspend fun restrictionType(`value`: Output<String>) {
        this.restrictionType = value
    }

    /**
     * @param value [ISO 3166-1-alpha-2 codes][4] for which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`). If the type is specified as `none` an empty array can be used.
     */
    @JvmName("bssqrvdyojvbkdkj")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values [ISO 3166-1-alpha-2 codes][4] for which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`). If the type is specified as `none` an empty array can be used.
     */
    @JvmName("dtmxahntlcxmngcd")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value Method that you want to use to restrict distribution of your content by country: `none`, `whitelist`, or `blacklist`.
     */
    @JvmName("nvbaiplgumsbsonr")
    public suspend fun restrictionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictionType = mapped
    }

    internal fun build(): DistributionRestrictionsGeoRestrictionArgs =
        DistributionRestrictionsGeoRestrictionArgs(
            locations = locations,
            restrictionType = restrictionType ?: throw PulumiNullFieldException("restrictionType"),
        )
}
