@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentType he content type for a field-level encryption content type-profile mapping. Valid value is `application/x-www-form-urlencoded`.
 * @property format The format for a field-level encryption content type-profile mapping. Valid value is `URLEncoded`.
 * @property profileId
 */
public data class FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs(
    public val contentType: Output<String>,
    public val format: Output<String>,
    public val profileId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs =
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs.builder()
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .format(format.applyValue({ args0 -> args0 }))
            .profileId(profileId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgsBuilder
internal constructor() {
    private var contentType: Output<String>? = null

    private var format: Output<String>? = null

    private var profileId: Output<String>? = null

    /**
     * @param value he content type for a field-level encryption content type-profile mapping. Valid value is `application/x-www-form-urlencoded`.
     */
    @JvmName("nnoqenxmqyhicupk")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The format for a field-level encryption content type-profile mapping. Valid value is `URLEncoded`.
     */
    @JvmName("cihsloikqbnpveyj")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value
     */
    @JvmName("xdpvttsaiekhnyvd")
    public suspend fun profileId(`value`: Output<String>) {
        this.profileId = value
    }

    /**
     * @param value he content type for a field-level encryption content type-profile mapping. Valid value is `application/x-www-form-urlencoded`.
     */
    @JvmName("rmvdgogtfsrhkodl")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The format for a field-level encryption content type-profile mapping. Valid value is `URLEncoded`.
     */
    @JvmName("omecjamojynptmlh")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value
     */
    @JvmName("kgyjuphyolfnehlg")
    public suspend fun profileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileId = mapped
    }

    internal fun build(): FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs =
        FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs(
            contentType = contentType ?: throw PulumiNullFieldException("contentType"),
            format = format ?: throw PulumiNullFieldException("format"),
            profileId = profileId,
        )
}
