@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileId
 * @property queryArg Query argument for field-level encryption query argument-profile mapping.
 */
public data class FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs(
    public val profileId: Output<String>,
    public val queryArg: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs =
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs.builder()
            .profileId(profileId.applyValue({ args0 -> args0 }))
            .queryArg(queryArg.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgsBuilder internal constructor() {
    private var profileId: Output<String>? = null

    private var queryArg: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rprfumpxxsoreegt")
    public suspend fun profileId(`value`: Output<String>) {
        this.profileId = value
    }

    /**
     * @param value Query argument for field-level encryption query argument-profile mapping.
     */
    @JvmName("dbfumnwjfhxsghtt")
    public suspend fun queryArg(`value`: Output<String>) {
        this.queryArg = value
    }

    /**
     * @param value
     */
    @JvmName("evkrcthkdqvhbcsi")
    public suspend fun profileId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profileId = mapped
    }

    /**
     * @param value Query argument for field-level encryption query argument-profile mapping.
     */
    @JvmName("daeftvkdqyhvxexn")
    public suspend fun queryArg(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryArg = mapped
    }

    internal fun build(): FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs =
        FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs(
            profileId = profileId ?: throw PulumiNullFieldException("profileId"),
            queryArg = queryArg ?: throw PulumiNullFieldException("queryArg"),
        )
}
