@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldPatterns Object that contains an attribute `items` that contains the list of field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted.
 * @property providerId The provider associated with the public key being used for encryption.
 * @property publicKeyId The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match the patterns.
 */
public data class FieldLevelEncryptionProfileEncryptionEntitiesItemArgs(
    public val fieldPatterns: Output<FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs>,
    public val providerId: Output<String>,
    public val publicKeyId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs =
        com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesItemArgs.builder()
            .fieldPatterns(fieldPatterns.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerId(providerId.applyValue({ args0 -> args0 }))
            .publicKeyId(publicKeyId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldLevelEncryptionProfileEncryptionEntitiesItemArgs].
 */
@PulumiTagMarker
public class FieldLevelEncryptionProfileEncryptionEntitiesItemArgsBuilder internal constructor() {
    private var fieldPatterns:
        Output<FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs>? = null

    private var providerId: Output<String>? = null

    private var publicKeyId: Output<String>? = null

    /**
     * @param value Object that contains an attribute `items` that contains the list of field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted.
     */
    @JvmName("wgvckbuhbknbsjho")
    public suspend fun fieldPatterns(`value`: Output<FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs>) {
        this.fieldPatterns = value
    }

    /**
     * @param value The provider associated with the public key being used for encryption.
     */
    @JvmName("beygwrmrepibhpwv")
    public suspend fun providerId(`value`: Output<String>) {
        this.providerId = value
    }

    /**
     * @param value The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match the patterns.
     */
    @JvmName("iuuqwugqjtwrmysu")
    public suspend fun publicKeyId(`value`: Output<String>) {
        this.publicKeyId = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains the list of field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted.
     */
    @JvmName("nvjksyehgguwxyjb")
    public suspend fun fieldPatterns(`value`: FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldPatterns = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains the list of field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted.
     */
    @JvmName("xxcwbcetwunqpahu")
    public suspend fun fieldPatterns(argument: suspend FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldPatterns = mapped
    }

    /**
     * @param value The provider associated with the public key being used for encryption.
     */
    @JvmName("ngdkjdhqmcpkogum")
    public suspend fun providerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerId = mapped
    }

    /**
     * @param value The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match the patterns.
     */
    @JvmName("xocipmnxbtpdookn")
    public suspend fun publicKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeyId = mapped
    }

    internal fun build(): FieldLevelEncryptionProfileEncryptionEntitiesItemArgs =
        FieldLevelEncryptionProfileEncryptionEntitiesItemArgs(
            fieldPatterns = fieldPatterns ?: throw PulumiNullFieldException("fieldPatterns"),
            providerId = providerId ?: throw PulumiNullFieldException("providerId"),
            publicKeyId = publicKeyId ?: throw PulumiNullFieldException("publicKeyId"),
        )
}
