@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetCachePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCachePolicy.
 * @property id Identifier for the cache policy.
 * @property name Unique name to identify the cache policy.
 */
public data class GetCachePolicyPlainArgs(
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetCachePolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetCachePolicyPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetCachePolicyPlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCachePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetCachePolicyPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    /**
     * @param value Identifier for the cache policy.
     */
    @JvmName("xxbarociyawokfan")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Unique name to identify the cache policy.
     */
    @JvmName("vigmumecnxifefor")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetCachePolicyPlainArgs = GetCachePolicyPlainArgs(
        id = id,
        name = name,
    )
}
