@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetFunctionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFunction.
 * @property name Name of the CloudFront function.
 * @property stage Function’s stage, either `DEVELOPMENT` or `LIVE`.
 */
public data class GetFunctionPlainArgs(
    public val name: String,
    public val stage: String,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetFunctionPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetFunctionPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetFunctionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .stage(stage.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFunctionPlainArgs].
 */
@PulumiTagMarker
public class GetFunctionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var stage: String? = null

    /**
     * @param value Name of the CloudFront function.
     */
    @JvmName("ntyfpykqljufkock")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Function’s stage, either `DEVELOPMENT` or `LIVE`.
     */
    @JvmName("sgqlkpvrqmgsjrxc")
    public suspend fun stage(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stage = mapped
    }

    internal fun build(): GetFunctionPlainArgs = GetFunctionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        stage = stage ?: throw PulumiNullFieldException("stage"),
    )
}
