@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetOriginAccessControlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOriginAccessControl.
 * @property id The identifier for the origin access control settings. For example: `E2T5VTFBZJ3BJB`.
 */
public data class GetOriginAccessControlPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetOriginAccessControlPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetOriginAccessControlPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetOriginAccessControlPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOriginAccessControlPlainArgs].
 */
@PulumiTagMarker
public class GetOriginAccessControlPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value The identifier for the origin access control settings. For example: `E2T5VTFBZJ3BJB`.
     */
    @JvmName("sbywcmtjekpkeplg")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetOriginAccessControlPlainArgs = GetOriginAccessControlPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
