@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOriginAccessIdentity.
 * @property id The identifier for the origin access identity. For example: `E1ZAKK699EOLAL`.
 */
public data class GetOriginAccessIdentityPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentityPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentityPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetOriginAccessIdentityPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOriginAccessIdentityPlainArgs].
 */
@PulumiTagMarker
public class GetOriginAccessIdentityPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value The identifier for the origin access identity. For example: `E1ZAKK699EOLAL`.
     */
    @JvmName("amhuhvujiapoasee")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetOriginAccessIdentityPlainArgs = GetOriginAccessIdentityPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
