@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetRealtimeLogConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRealtimeLogConfig.
 * @property name Unique name to identify this real-time log configuration.
 */
public data class GetRealtimeLogConfigPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetRealtimeLogConfigPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetRealtimeLogConfigPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetRealtimeLogConfigPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRealtimeLogConfigPlainArgs].
 */
@PulumiTagMarker
public class GetRealtimeLogConfigPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Unique name to identify this real-time log configuration.
     */
    @JvmName("fmvlbfdwffkhxisk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetRealtimeLogConfigPlainArgs = GetRealtimeLogConfigPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
