@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResponseHeadersPolicy.
 * @property id Identifier for the response headers policy.
 * @property name Unique name to identify the response headers policy.
 */
public data class GetResponseHeadersPolicyPlainArgs(
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyPlainArgs =
        com.pulumi.aws.cloudfront.inputs.GetResponseHeadersPolicyPlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResponseHeadersPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetResponseHeadersPolicyPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    /**
     * @param value Identifier for the response headers policy.
     */
    @JvmName("xiylaukceqlibaos")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Unique name to identify the response headers policy.
     */
    @JvmName("ivgpotttlqhfqeoa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetResponseHeadersPolicyPlainArgs = GetResponseHeadersPolicyPlainArgs(
        id = id,
        name = name,
    )
}
