@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property realtimeMetricsSubscriptionStatus A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution. Valid values are `Enabled` and `Disabled`. See below.
 */
public data class MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs(
    public val realtimeMetricsSubscriptionStatus: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs =
        com.pulumi.aws.cloudfront.inputs.MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs.builder()
            .realtimeMetricsSubscriptionStatus(
                realtimeMetricsSubscriptionStatus.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs].
 */
@PulumiTagMarker
public class
MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgsBuilder
internal constructor() {
    private var realtimeMetricsSubscriptionStatus: Output<String>? = null

    /**
     * @param value A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution. Valid values are `Enabled` and `Disabled`. See below.
     */
    @JvmName("cvvqofbluibdshhq")
    public suspend fun realtimeMetricsSubscriptionStatus(`value`: Output<String>) {
        this.realtimeMetricsSubscriptionStatus = value
    }

    /**
     * @param value A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution. Valid values are `Enabled` and `Disabled`. See below.
     */
    @JvmName("ymarmyniciedxqtt")
    public suspend fun realtimeMetricsSubscriptionStatus(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.realtimeMetricsSubscriptionStatus = mapped
    }

    internal fun build(): MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs =
        MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs(
            realtimeMetricsSubscriptionStatus = realtimeMetricsSubscriptionStatus ?: throw
                PulumiNullFieldException("realtimeMetricsSubscriptionStatus"),
        )
}
