@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cookieBehavior
 * @property cookies
 */
public data class OriginRequestPolicyCookiesConfigArgs(
    public val cookieBehavior: Output<String>,
    public val cookies: Output<OriginRequestPolicyCookiesConfigCookiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigArgs =
        com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyCookiesConfigArgs.builder()
            .cookieBehavior(cookieBehavior.applyValue({ args0 -> args0 }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OriginRequestPolicyCookiesConfigArgs].
 */
@PulumiTagMarker
public class OriginRequestPolicyCookiesConfigArgsBuilder internal constructor() {
    private var cookieBehavior: Output<String>? = null

    private var cookies: Output<OriginRequestPolicyCookiesConfigCookiesArgs>? = null

    /**
     * @param value
     */
    @JvmName("qlwextagioxedrcp")
    public suspend fun cookieBehavior(`value`: Output<String>) {
        this.cookieBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("eegeflxkvcbwcqvd")
    public suspend fun cookies(`value`: Output<OriginRequestPolicyCookiesConfigCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value
     */
    @JvmName("vgocpjimfaroiodp")
    public suspend fun cookieBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookieBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("vqjdtpnydpdeases")
    public suspend fun cookies(`value`: OriginRequestPolicyCookiesConfigCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ohmufvdkrldkword")
    public suspend fun cookies(argument: suspend OriginRequestPolicyCookiesConfigCookiesArgsBuilder.() -> Unit) {
        val toBeMapped = OriginRequestPolicyCookiesConfigCookiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    internal fun build(): OriginRequestPolicyCookiesConfigArgs = OriginRequestPolicyCookiesConfigArgs(
        cookieBehavior = cookieBehavior ?: throw PulumiNullFieldException("cookieBehavior"),
        cookies = cookies,
    )
}
