@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property queryStringBehavior
 * @property queryStrings
 */
public data class OriginRequestPolicyQueryStringsConfigArgs(
    public val queryStringBehavior: Output<String>,
    public val queryStrings: Output<OriginRequestPolicyQueryStringsConfigQueryStringsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigArgs = com.pulumi.aws.cloudfront.inputs.OriginRequestPolicyQueryStringsConfigArgs.builder()
        .queryStringBehavior(queryStringBehavior.applyValue({ args0 -> args0 }))
        .queryStrings(queryStrings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OriginRequestPolicyQueryStringsConfigArgs].
 */
@PulumiTagMarker
public class OriginRequestPolicyQueryStringsConfigArgsBuilder internal constructor() {
    private var queryStringBehavior: Output<String>? = null

    private var queryStrings: Output<OriginRequestPolicyQueryStringsConfigQueryStringsArgs>? = null

    /**
     * @param value
     */
    @JvmName("uaqnrvgfebkfgeqn")
    public suspend fun queryStringBehavior(`value`: Output<String>) {
        this.queryStringBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("jsdsyaxbskblrrxp")
    public suspend fun queryStrings(`value`: Output<OriginRequestPolicyQueryStringsConfigQueryStringsArgs>) {
        this.queryStrings = value
    }

    /**
     * @param value
     */
    @JvmName("qrbtyhkvwrxlylvg")
    public suspend fun queryStringBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("pqhokujtrcfvwael")
    public suspend fun queryStrings(`value`: OriginRequestPolicyQueryStringsConfigQueryStringsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aktppjspxqhbgjop")
    public suspend fun queryStrings(argument: suspend OriginRequestPolicyQueryStringsConfigQueryStringsArgsBuilder.() -> Unit) {
        val toBeMapped = OriginRequestPolicyQueryStringsConfigQueryStringsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    internal fun build(): OriginRequestPolicyQueryStringsConfigArgs =
        OriginRequestPolicyQueryStringsConfigArgs(
            queryStringBehavior = queryStringBehavior ?: throw PulumiNullFieldException("queryStringBehavior"),
            queryStrings = queryStrings,
        )
}
