@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kinesisStreamConfig The Amazon Kinesis data stream configuration.
 * @property streamType The type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
 */
public data class RealtimeLogConfigEndpointArgs(
    public val kinesisStreamConfig: Output<RealtimeLogConfigEndpointKinesisStreamConfigArgs>,
    public val streamType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs =
        com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs.builder()
            .kinesisStreamConfig(
                kinesisStreamConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .streamType(streamType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RealtimeLogConfigEndpointArgs].
 */
@PulumiTagMarker
public class RealtimeLogConfigEndpointArgsBuilder internal constructor() {
    private var kinesisStreamConfig: Output<RealtimeLogConfigEndpointKinesisStreamConfigArgs>? = null

    private var streamType: Output<String>? = null

    /**
     * @param value The Amazon Kinesis data stream configuration.
     */
    @JvmName("xdnyqpjylywasxbk")
    public suspend fun kinesisStreamConfig(`value`: Output<RealtimeLogConfigEndpointKinesisStreamConfigArgs>) {
        this.kinesisStreamConfig = value
    }

    /**
     * @param value The type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
     */
    @JvmName("eanlbwyjxfopugxg")
    public suspend fun streamType(`value`: Output<String>) {
        this.streamType = value
    }

    /**
     * @param value The Amazon Kinesis data stream configuration.
     */
    @JvmName("lfwuwaipttcubknq")
    public suspend fun kinesisStreamConfig(`value`: RealtimeLogConfigEndpointKinesisStreamConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kinesisStreamConfig = mapped
    }

    /**
     * @param argument The Amazon Kinesis data stream configuration.
     */
    @JvmName("kfyttvjbrlwqtuaf")
    public suspend fun kinesisStreamConfig(argument: suspend RealtimeLogConfigEndpointKinesisStreamConfigArgsBuilder.() -> Unit) {
        val toBeMapped = RealtimeLogConfigEndpointKinesisStreamConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisStreamConfig = mapped
    }

    /**
     * @param value The type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
     */
    @JvmName("mrdykexyyhdkdnwk")
    public suspend fun streamType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamType = mapped
    }

    internal fun build(): RealtimeLogConfigEndpointArgs = RealtimeLogConfigEndpointArgs(
        kinesisStreamConfig = kinesisStreamConfig ?: throw PulumiNullFieldException("kinesisStreamConfig"),
        streamType = streamType ?: throw PulumiNullFieldException("streamType"),
    )
}
