@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn The ARN of an IAM role that CloudFront can use to send real-time log data to the Kinesis data stream.
 * See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) for more information.
 * @property streamArn The ARN of the Kinesis data stream.
 */
public data class RealtimeLogConfigEndpointKinesisStreamConfigArgs(
    public val roleArn: Output<String>,
    public val streamArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs =
        com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointKinesisStreamConfigArgs.builder()
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .streamArn(streamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RealtimeLogConfigEndpointKinesisStreamConfigArgs].
 */
@PulumiTagMarker
public class RealtimeLogConfigEndpointKinesisStreamConfigArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var streamArn: Output<String>? = null

    /**
     * @param value The ARN of an IAM role that CloudFront can use to send real-time log data to the Kinesis data stream.
     * See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) for more information.
     */
    @JvmName("olssomifnrcnqebh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Kinesis data stream.
     */
    @JvmName("qkxgtstupcmwbsdf")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value The ARN of an IAM role that CloudFront can use to send real-time log data to the Kinesis data stream.
     * See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) for more information.
     */
    @JvmName("mgbjlegdciephipn")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The ARN of the Kinesis data stream.
     */
    @JvmName("etcjriwooviidvfg")
    public suspend fun streamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    internal fun build(): RealtimeLogConfigEndpointKinesisStreamConfigArgs =
        RealtimeLogConfigEndpointKinesisStreamConfigArgs(
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            streamArn = streamArn ?: throw PulumiNullFieldException("streamArn"),
        )
}
