@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlAllowCredentials A Boolean value that CloudFront uses as the value for the `Access-Control-Allow-Credentials` HTTP response header.
 * @property accessControlAllowHeaders Object that contains an attribute `items` that contains a list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
 * @property accessControlAllowMethods Object that contains an attribute `items` that contains a list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header. Valid values: `GET` | `POST` | `OPTIONS` | `PUT` | `DELETE` | `HEAD` | `ALL`
 * @property accessControlAllowOrigins Object that contains an attribute `items` that contains a list of origins that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
 * @property accessControlExposeHeaders Object that contains an attribute `items` that contains a list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
 * @property accessControlMaxAgeSec A number that CloudFront uses as the value for the `Access-Control-Max-Age` HTTP response header.
 * @property originOverride A Boolean value that determines how CloudFront behaves for the HTTP response header.
 */
public data class ResponseHeadersPolicyCorsConfigArgs(
    public val accessControlAllowCredentials: Output<Boolean>,
    public val accessControlAllowHeaders: Output<ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs>,
    public val accessControlAllowMethods: Output<ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs>,
    public val accessControlAllowOrigins: Output<ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs>,
    public val accessControlExposeHeaders: Output<ResponseHeadersPolicyCorsConfigAccessControlExposeHeadersArgs>? = null,
    public val accessControlMaxAgeSec: Output<Int>? = null,
    public val originOverride: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs.builder()
            .accessControlAllowCredentials(accessControlAllowCredentials.applyValue({ args0 -> args0 }))
            .accessControlAllowHeaders(
                accessControlAllowHeaders.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .accessControlAllowMethods(
                accessControlAllowMethods.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .accessControlAllowOrigins(
                accessControlAllowOrigins.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .accessControlExposeHeaders(
                accessControlExposeHeaders?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .accessControlMaxAgeSec(accessControlMaxAgeSec?.applyValue({ args0 -> args0 }))
            .originOverride(originOverride.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicyCorsConfigArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicyCorsConfigArgsBuilder internal constructor() {
    private var accessControlAllowCredentials: Output<Boolean>? = null

    private var accessControlAllowHeaders:
        Output<ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs>? = null

    private var accessControlAllowMethods:
        Output<ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs>? = null

    private var accessControlAllowOrigins:
        Output<ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs>? = null

    private var accessControlExposeHeaders:
        Output<ResponseHeadersPolicyCorsConfigAccessControlExposeHeadersArgs>? = null

    private var accessControlMaxAgeSec: Output<Int>? = null

    private var originOverride: Output<Boolean>? = null

    /**
     * @param value A Boolean value that CloudFront uses as the value for the `Access-Control-Allow-Credentials` HTTP response header.
     */
    @JvmName("qmvixoaovxpsfetb")
    public suspend fun accessControlAllowCredentials(`value`: Output<Boolean>) {
        this.accessControlAllowCredentials = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
     */
    @JvmName("bgctjcynvighgoys")
    public suspend fun accessControlAllowHeaders(`value`: Output<ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs>) {
        this.accessControlAllowHeaders = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header. Valid values: `GET` | `POST` | `OPTIONS` | `PUT` | `DELETE` | `HEAD` | `ALL`
     */
    @JvmName("byhaelflbjivdbrg")
    public suspend fun accessControlAllowMethods(`value`: Output<ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs>) {
        this.accessControlAllowMethods = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of origins that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
     */
    @JvmName("tykuedbfedeskfnq")
    public suspend fun accessControlAllowOrigins(`value`: Output<ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs>) {
        this.accessControlAllowOrigins = value
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
     */
    @JvmName("xjksdrcvackwcebr")
    public suspend fun accessControlExposeHeaders(`value`: Output<ResponseHeadersPolicyCorsConfigAccessControlExposeHeadersArgs>) {
        this.accessControlExposeHeaders = value
    }

    /**
     * @param value A number that CloudFront uses as the value for the `Access-Control-Max-Age` HTTP response header.
     */
    @JvmName("qbetdvepoemknarh")
    public suspend fun accessControlMaxAgeSec(`value`: Output<Int>) {
        this.accessControlMaxAgeSec = value
    }

    /**
     * @param value A Boolean value that determines how CloudFront behaves for the HTTP response header.
     */
    @JvmName("xtaodueldvuxmblf")
    public suspend fun originOverride(`value`: Output<Boolean>) {
        this.originOverride = value
    }

    /**
     * @param value A Boolean value that CloudFront uses as the value for the `Access-Control-Allow-Credentials` HTTP response header.
     */
    @JvmName("cnecetwbmwlkwyac")
    public suspend fun accessControlAllowCredentials(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlAllowCredentials = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
     */
    @JvmName("ucjcspmrchtudttm")
    public suspend fun accessControlAllowHeaders(`value`: ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlAllowHeaders = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains a list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
     */
    @JvmName("qpeyqgcuwfphlmvv")
    public suspend fun accessControlAllowHeaders(argument: suspend ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessControlAllowHeaders = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header. Valid values: `GET` | `POST` | `OPTIONS` | `PUT` | `DELETE` | `HEAD` | `ALL`
     */
    @JvmName("tvroymkowjcswfsb")
    public suspend fun accessControlAllowMethods(`value`: ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlAllowMethods = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains a list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header. Valid values: `GET` | `POST` | `OPTIONS` | `PUT` | `DELETE` | `HEAD` | `ALL`
     */
    @JvmName("oumwskvpyqcdntgk")
    public suspend fun accessControlAllowMethods(argument: suspend ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessControlAllowMethods = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of origins that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
     */
    @JvmName("icdaaortbartxjsb")
    public suspend fun accessControlAllowOrigins(`value`: ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlAllowOrigins = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains a list of origins that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
     */
    @JvmName("bucpbyjbcagnvffx")
    public suspend fun accessControlAllowOrigins(argument: suspend ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessControlAllowOrigins = mapped
    }

    /**
     * @param value Object that contains an attribute `items` that contains a list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
     */
    @JvmName("scuyxlbkcpebtvrt")
    public suspend fun accessControlExposeHeaders(`value`: ResponseHeadersPolicyCorsConfigAccessControlExposeHeadersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlExposeHeaders = mapped
    }

    /**
     * @param argument Object that contains an attribute `items` that contains a list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
     */
    @JvmName("qcvkjqqhnynthhwu")
    public suspend fun accessControlExposeHeaders(argument: suspend ResponseHeadersPolicyCorsConfigAccessControlExposeHeadersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicyCorsConfigAccessControlExposeHeadersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accessControlExposeHeaders = mapped
    }

    /**
     * @param value A number that CloudFront uses as the value for the `Access-Control-Max-Age` HTTP response header.
     */
    @JvmName("ghdoolhgwxiausui")
    public suspend fun accessControlMaxAgeSec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlMaxAgeSec = mapped
    }

    /**
     * @param value A Boolean value that determines how CloudFront behaves for the HTTP response header.
     */
    @JvmName("ucgtyeoqcrcplryc")
    public suspend fun originOverride(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.originOverride = mapped
    }

    internal fun build(): ResponseHeadersPolicyCorsConfigArgs = ResponseHeadersPolicyCorsConfigArgs(
        accessControlAllowCredentials = accessControlAllowCredentials ?: throw
            PulumiNullFieldException("accessControlAllowCredentials"),
        accessControlAllowHeaders = accessControlAllowHeaders ?: throw
            PulumiNullFieldException("accessControlAllowHeaders"),
        accessControlAllowMethods = accessControlAllowMethods ?: throw
            PulumiNullFieldException("accessControlAllowMethods"),
        accessControlAllowOrigins = accessControlAllowOrigins ?: throw
            PulumiNullFieldException("accessControlAllowOrigins"),
        accessControlExposeHeaders = accessControlExposeHeaders,
        accessControlMaxAgeSec = accessControlMaxAgeSec,
        originOverride = originOverride ?: throw PulumiNullFieldException("originOverride"),
    )
}
