@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header. See Content Security Policy for more information.
 * @property contentTypeOptions Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`. See Content Type Options for more information.
 * @property frameOptions Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header’s value. See Frame Options for more information.
 * @property referrerPolicy Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header’s value. See Referrer Policy for more information.
 * @property strictTransportSecurity Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header’s value. See Strict Transport Security for more information.
 * @property xssProtection Determine whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header’s value. See XSS Protection for more information.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigArgs(
    public val contentSecurityPolicy: Output<ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs>? = null,
    public val contentTypeOptions: Output<ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs>? = null,
    public val frameOptions: Output<ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs>? =
        null,
    public val referrerPolicy: Output<ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs>? =
        null,
    public val strictTransportSecurity: Output<ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs>? = null,
    public val xssProtection: Output<ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigArgs.builder()
            .contentSecurityPolicy(
                contentSecurityPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .contentTypeOptions(
                contentTypeOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frameOptions(frameOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .referrerPolicy(referrerPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .strictTransportSecurity(
                strictTransportSecurity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .xssProtection(xssProtection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigArgsBuilder internal constructor() {
    private var contentSecurityPolicy:
        Output<ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs>? = null

    private var contentTypeOptions:
        Output<ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs>? = null

    private var frameOptions: Output<ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs>? =
        null

    private var referrerPolicy: Output<ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs>? =
        null

    private var strictTransportSecurity:
        Output<ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs>? = null

    private var xssProtection: Output<ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs>? =
        null

    /**
     * @param value The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header. See Content Security Policy for more information.
     */
    @JvmName("pkgnjmyheahqwact")
    public suspend fun contentSecurityPolicy(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs>) {
        this.contentSecurityPolicy = value
    }

    /**
     * @param value Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`. See Content Type Options for more information.
     */
    @JvmName("cvvjwpbicjsdatjc")
    public suspend fun contentTypeOptions(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs>) {
        this.contentTypeOptions = value
    }

    /**
     * @param value Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header’s value. See Frame Options for more information.
     */
    @JvmName("bagnfmyefsxdsned")
    public suspend fun frameOptions(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs>) {
        this.frameOptions = value
    }

    /**
     * @param value Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header’s value. See Referrer Policy for more information.
     */
    @JvmName("dnfctnbbxucoxneu")
    public suspend fun referrerPolicy(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs>) {
        this.referrerPolicy = value
    }

    /**
     * @param value Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header’s value. See Strict Transport Security for more information.
     */
    @JvmName("xhfnxguxnlyojbvw")
    public suspend fun strictTransportSecurity(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs>) {
        this.strictTransportSecurity = value
    }

    /**
     * @param value Determine whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header’s value. See XSS Protection for more information.
     */
    @JvmName("imbanrrrjsxgexju")
    public suspend fun xssProtection(`value`: Output<ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs>) {
        this.xssProtection = value
    }

    /**
     * @param value The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header. See Content Security Policy for more information.
     */
    @JvmName("volguupxofoytgje")
    public suspend fun contentSecurityPolicy(`value`: ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentSecurityPolicy = mapped
    }

    /**
     * @param argument The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header. See Content Security Policy for more information.
     */
    @JvmName("wgtifhykmqefhblx")
    public suspend fun contentSecurityPolicy(argument: suspend ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.contentSecurityPolicy = mapped
    }

    /**
     * @param value Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`. See Content Type Options for more information.
     */
    @JvmName("fuenctcgmpeykcny")
    public suspend fun contentTypeOptions(`value`: ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypeOptions = mapped
    }

    /**
     * @param argument Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`. See Content Type Options for more information.
     */
    @JvmName("evfcpvfuewftwcht")
    public suspend fun contentTypeOptions(argument: suspend ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicySecurityHeadersConfigContentTypeOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.contentTypeOptions = mapped
    }

    /**
     * @param value Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header’s value. See Frame Options for more information.
     */
    @JvmName("ntsidwfldtnjpfrg")
    public suspend fun frameOptions(`value`: ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameOptions = mapped
    }

    /**
     * @param argument Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header’s value. See Frame Options for more information.
     */
    @JvmName("exhtdbfkqniylnus")
    public suspend fun frameOptions(argument: suspend ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.frameOptions = mapped
    }

    /**
     * @param value Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header’s value. See Referrer Policy for more information.
     */
    @JvmName("iawdopolyoedeyai")
    public suspend fun referrerPolicy(`value`: ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referrerPolicy = mapped
    }

    /**
     * @param argument Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header’s value. See Referrer Policy for more information.
     */
    @JvmName("vcqliienyhfsxknn")
    public suspend fun referrerPolicy(argument: suspend ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicySecurityHeadersConfigReferrerPolicyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.referrerPolicy = mapped
    }

    /**
     * @param value Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header’s value. See Strict Transport Security for more information.
     */
    @JvmName("inefpwbvdakcgyyn")
    public suspend fun strictTransportSecurity(`value`: ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strictTransportSecurity = mapped
    }

    /**
     * @param argument Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header’s value. See Strict Transport Security for more information.
     */
    @JvmName("piirllugsmtyyxiy")
    public suspend fun strictTransportSecurity(argument: suspend ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.strictTransportSecurity = mapped
    }

    /**
     * @param value Determine whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header’s value. See XSS Protection for more information.
     */
    @JvmName("sgvdugtkddppoiyd")
    public suspend fun xssProtection(`value`: ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssProtection = mapped
    }

    /**
     * @param argument Determine whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header’s value. See XSS Protection for more information.
     */
    @JvmName("fmsqqujtmxrayhvs")
    public suspend fun xssProtection(argument: suspend ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResponseHeadersPolicySecurityHeadersConfigXssProtectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.xssProtection = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigArgs =
        ResponseHeadersPolicySecurityHeadersConfigArgs(
            contentSecurityPolicy = contentSecurityPolicy,
            contentTypeOptions = contentTypeOptions,
            frameOptions = frameOptions,
            referrerPolicy = referrerPolicy,
            strictTransportSecurity = strictTransportSecurity,
            xssProtection = xssProtection,
        )
}
