@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header.
 * @property override Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs(
    public val contentSecurityPolicy: Output<String>,
    public val `override`: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs.builder()
            .contentSecurityPolicy(contentSecurityPolicy.applyValue({ args0 -> args0 }))
            .`override`(`override`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgsBuilder internal constructor() {
    private var contentSecurityPolicy: Output<String>? = null

    private var `override`: Output<Boolean>? = null

    /**
     * @param value The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header.
     */
    @JvmName("qnexrmkfkqofrbjg")
    public suspend fun contentSecurityPolicy(`value`: Output<String>) {
        this.contentSecurityPolicy = value
    }

    /**
     * @param value Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("ehtrtnchpnevgfll")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header.
     */
    @JvmName("eokbyfvhbtbtasgo")
    public suspend fun contentSecurityPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentSecurityPolicy = mapped
    }

    /**
     * @param value Whether CloudFront overrides the `Content-Security-Policy` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("eekkacsugposboog")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs =
        ResponseHeadersPolicySecurityHeadersConfigContentSecurityPolicyArgs(
            contentSecurityPolicy = contentSecurityPolicy ?: throw
                PulumiNullFieldException("contentSecurityPolicy"),
            `override` = `override` ?: throw PulumiNullFieldException("override"),
        )
}
