@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frameOption The value of the `X-Frame-Options` HTTP response header. Valid values: `DENY` | `SAMEORIGIN`
 * @property override Whether CloudFront overrides the `X-Frame-Options` HTTP response header received from the origin with the one specified in this response headers policy.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs(
    public val frameOption: Output<String>,
    public val `override`: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs.builder()
            .frameOption(frameOption.applyValue({ args0 -> args0 }))
            .`override`(`override`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgsBuilder internal constructor() {
    private var frameOption: Output<String>? = null

    private var `override`: Output<Boolean>? = null

    /**
     * @param value The value of the `X-Frame-Options` HTTP response header. Valid values: `DENY` | `SAMEORIGIN`
     */
    @JvmName("adsoacchnttaebnj")
    public suspend fun frameOption(`value`: Output<String>) {
        this.frameOption = value
    }

    /**
     * @param value Whether CloudFront overrides the `X-Frame-Options` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("vtrssdipvwgkjgbx")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value The value of the `X-Frame-Options` HTTP response header. Valid values: `DENY` | `SAMEORIGIN`
     */
    @JvmName("kqfewwtqnstjkqdx")
    public suspend fun frameOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frameOption = mapped
    }

    /**
     * @param value Whether CloudFront overrides the `X-Frame-Options` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("edegryoblhpworun")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs =
        ResponseHeadersPolicySecurityHeadersConfigFrameOptionsArgs(
            frameOption = frameOption ?: throw PulumiNullFieldException("frameOption"),
            `override` = `override` ?: throw PulumiNullFieldException("override"),
        )
}
