@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudfront.kotlin.inputs

import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlMaxAgeSec A number that CloudFront uses as the value for the `max-age` directive in the `Strict-Transport-Security` HTTP response header.
 * @property includeSubdomains Whether CloudFront includes the `includeSubDomains` directive in the `Strict-Transport-Security` HTTP response header.
 * @property override Whether CloudFront overrides the `Strict-Transport-Security` HTTP response header received from the origin with the one specified in this response headers policy.
 * @property preload Whether CloudFront includes the `preload` directive in the `Strict-Transport-Security` HTTP response header.
 */
public data class ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs(
    public val accessControlMaxAgeSec: Output<Int>,
    public val includeSubdomains: Output<Boolean>? = null,
    public val `override`: Output<Boolean>,
    public val preload: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs> {
    override fun toJava(): com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs =
        com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs.builder()
            .accessControlMaxAgeSec(accessControlMaxAgeSec.applyValue({ args0 -> args0 }))
            .includeSubdomains(includeSubdomains?.applyValue({ args0 -> args0 }))
            .`override`(`override`.applyValue({ args0 -> args0 }))
            .preload(preload?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs].
 */
@PulumiTagMarker
public class ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgsBuilder internal constructor() {
    private var accessControlMaxAgeSec: Output<Int>? = null

    private var includeSubdomains: Output<Boolean>? = null

    private var `override`: Output<Boolean>? = null

    private var preload: Output<Boolean>? = null

    /**
     * @param value A number that CloudFront uses as the value for the `max-age` directive in the `Strict-Transport-Security` HTTP response header.
     */
    @JvmName("febbasvdqjajkmdn")
    public suspend fun accessControlMaxAgeSec(`value`: Output<Int>) {
        this.accessControlMaxAgeSec = value
    }

    /**
     * @param value Whether CloudFront includes the `includeSubDomains` directive in the `Strict-Transport-Security` HTTP response header.
     */
    @JvmName("lxpbllibxiuilnid")
    public suspend fun includeSubdomains(`value`: Output<Boolean>) {
        this.includeSubdomains = value
    }

    /**
     * @param value Whether CloudFront overrides the `Strict-Transport-Security` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("kkwusxmkduvdenvn")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value Whether CloudFront includes the `preload` directive in the `Strict-Transport-Security` HTTP response header.
     */
    @JvmName("ilufwkcptackdfoo")
    public suspend fun preload(`value`: Output<Boolean>) {
        this.preload = value
    }

    /**
     * @param value A number that CloudFront uses as the value for the `max-age` directive in the `Strict-Transport-Security` HTTP response header.
     */
    @JvmName("wnsojyymjatrxcuc")
    public suspend fun accessControlMaxAgeSec(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlMaxAgeSec = mapped
    }

    /**
     * @param value Whether CloudFront includes the `includeSubDomains` directive in the `Strict-Transport-Security` HTTP response header.
     */
    @JvmName("nprrducwkqgncjfs")
    public suspend fun includeSubdomains(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeSubdomains = mapped
    }

    /**
     * @param value Whether CloudFront overrides the `Strict-Transport-Security` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @JvmName("kbinohcghtnricxs")
    public suspend fun `override`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    /**
     * @param value Whether CloudFront includes the `preload` directive in the `Strict-Transport-Security` HTTP response header.
     */
    @JvmName("onxdsvtyhtxalgug")
    public suspend fun preload(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preload = mapped
    }

    internal fun build(): ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs =
        ResponseHeadersPolicySecurityHeadersConfigStrictTransportSecurityArgs(
            accessControlMaxAgeSec = accessControlMaxAgeSec ?: throw
                PulumiNullFieldException("accessControlMaxAgeSec"),
            includeSubdomains = includeSubdomains,
            `override` = `override` ?: throw PulumiNullFieldException("override"),
            preload = preload,
        )
}
